/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jni.access.JNIAccessibleClass;
import com.oracle.svm.core.jni.access.JNIReflectionDictionary;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.hosted.CodeBreakdownProvider;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.HeapBreakdownProvider;
import com.oracle.svm.hosted.Log4ShellFeature;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import com.oracle.svm.hosted.jdk.JNIRegistrationSupport;
import com.oracle.svm.hosted.util.CPUTypeAArch64;
import com.oracle.svm.hosted.util.CPUTypeAMD64;
import com.oracle.svm.util.LogUtils;
import java.util.List;
import java.util.function.Supplier;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class ProgressReporterFeature
implements InternalFeature {
    protected final ProgressReporter reporter = ProgressReporter.singleton();

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (SubstrateOptions.BuildOutputBreakdowns.getValue().booleanValue()) {
            ImageSingletons.add(HeapBreakdownProvider.class, (Object)new HeapBreakdownProvider());
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        this.reporter.reportStageProgress();
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        if (SubstrateOptions.BuildOutputBreakdowns.getValue().booleanValue()) {
            ImageSingletons.add(CodeBreakdownProvider.class, (Object)new CodeBreakdownProvider(((FeatureImpl.AfterCompilationAccessImpl)access).getCompilationTasks()));
        }
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        if (SubstrateOptions.BuildOutputBreakdowns.getValue().booleanValue()) {
            HeapBreakdownProvider.singleton().calculate((FeatureImpl.BeforeImageWriteAccessImpl)access);
        }
    }

    protected void appendGraalSuffix(ProgressReporter.DirectPrinter graalLine) {
    }

    public void afterBreakdowns() {
        String userWarning = ((Log4ShellFeature)ImageSingletons.lookup(Log4ShellFeature.class)).getUserWarning();
        if (userWarning != null) {
            LogUtils.warning((String)userWarning);
        }
    }

    public void createAdditionalArtifactsOnSuccess(BuildArtifacts artifacts) {
    }

    protected List<UserRecommendation> getRecommendations() {
        return List.of(new UserRecommendation("INIT", "Adopt " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.StrictImageHeap, "+", "strict-image-heap", true, false) + " to prepare for the next GraalVM release.", () -> ClassInitializationOptions.StrictImageHeap.getValue() == false), new UserRecommendation("AWT", "Use the tracing agent to collect metadata for AWT.", ProgressReporterFeature::recommendTraceAgentForAWT), new UserRecommendation("HEAP", "Set max heap for improved and more predictable memory usage.", () -> SubstrateGCOptions.MaxHeapSize.getValue() == 0L), new UserRecommendation("CPU", "Enable more CPU features with '-march=native' for improved performance.", ProgressReporterFeature::recommendMArchNative));
    }

    private static boolean recommendMArchNative() {
        if (NativeImageOptions.MicroArchitecture.getValue() != null) {
            return false;
        }
        return switch (SubstrateUtil.getArchitectureName()) {
            case "aarch64" -> CPUTypeAArch64.nativeSupportsMoreFeaturesThanSelected();
            case "amd64" -> CPUTypeAMD64.nativeSupportsMoreFeaturesThanSelected();
            default -> false;
        };
    }

    private static boolean recommendTraceAgentForAWT() {
        if (!ImageSingletons.contains(JNIRegistrationSupport.class) || !ImageSingletons.contains(JNIReflectionDictionary.class)) {
            return false;
        }
        if (!JNIRegistrationSupport.singleton().isRegisteredLibrary("awt")) {
            return false;
        }
        for (JNIAccessibleClass clazz : JNIReflectionDictionary.singleton().getClasses()) {
            String className = clazz.getClassObject().getName();
            if (!className.startsWith("java.awt") && !className.startsWith("sun.awt")) continue;
            return false;
        }
        return true;
    }

    public record UserRecommendation(String id, String description, Supplier<Boolean> isApplicable) {
        public UserRecommendation {
            assert (id.toUpperCase().equals(id) && id.length() < 5) : "id must be uppercase and have fewer than 5 chars";
            int maxLength = 74;
            assert (description.length() < maxLength) : "description must have fewer than " + maxLength + " chars to fit in terminal. Length: " + description.length();
        }
    }
}

