/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import java.util.concurrent.atomic.AtomicLong;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.GraalError;

public class SubstrateHostedCompilationIdentifier
implements CompilationIdentifier {
    private static final AtomicLong uniqueStubIds = new AtomicLong();
    private final long id;
    private final ResolvedJavaMethod method;

    public SubstrateHostedCompilationIdentifier(ResolvedJavaMethod method) {
        this.method = method;
        this.id = uniqueStubIds.getAndIncrement();
    }

    public final String toString() {
        return this.toString(CompilationIdentifier.Verbosity.DETAILED);
    }

    public String toString(CompilationIdentifier.Verbosity verbosity) {
        return this.buildString(new StringBuilder(), verbosity).toString();
    }

    protected StringBuilder buildString(StringBuilder sb, CompilationIdentifier.Verbosity verbosity) {
        switch (verbosity) {
            case ID: {
                this.buildID(sb);
                break;
            }
            case NAME: {
                this.buildName(sb);
                break;
            }
            case DETAILED: {
                this.buildID(sb);
                sb.append('[');
                this.buildName(sb);
                sb.append(']');
                break;
            }
            default: {
                throw new GraalError("Unknown verbosity: " + String.valueOf(verbosity));
            }
        }
        return sb;
    }

    protected StringBuilder buildName(StringBuilder sb) {
        return sb.append(this.method.format("%H.%n(%p)"));
    }

    protected StringBuilder buildID(StringBuilder sb) {
        sb.append("SubstrateHostedCompilation-");
        return sb.append(this.id);
    }
}

