/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.truffle.isolated.IsolatedCompilationResultData;
import com.oracle.svm.truffle.isolated.IsolatedCompilationResultInfo;
import com.oracle.svm.truffle.isolated.IsolatedEventContext;
import com.oracle.svm.truffle.isolated.IsolatedGraphInfo;
import com.oracle.svm.truffle.isolated.IsolatedStringSupplier;
import com.oracle.truffle.compiler.TruffleCompilable;
import com.oracle.truffle.compiler.TruffleCompilationTask;
import com.oracle.truffle.compiler.TruffleCompilerListener;
import java.util.function.Supplier;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.ComparableWord;

final class IsolatedTruffleCompilerEventForwarder
implements TruffleCompilerListener {
    private final ClientHandle<IsolatedEventContext> contextHandle;

    IsolatedTruffleCompilerEventForwarder(ClientHandle<IsolatedEventContext> contextHandle) {
        this.contextHandle = contextHandle;
    }

    public void onGraalTierFinished(TruffleCompilable compilable, TruffleCompilerListener.GraphInfo graph) {
        IsolatedTruffleCompilerEventForwarder.onGraalTierFinished0(IsolatedCompileContext.get().getClient(), this.contextHandle, (CompilerHandle<TruffleCompilerListener.GraphInfo>)IsolatedCompileContext.get().hand((Object)graph), graph.getNodeCount());
    }

    public void onTruffleTierFinished(TruffleCompilable compilable, TruffleCompilationTask task, TruffleCompilerListener.GraphInfo graph) {
        IsolatedTruffleCompilerEventForwarder.onTruffleTierFinished0(IsolatedCompileContext.get().getClient(), this.contextHandle, (CompilerHandle<TruffleCompilerListener.GraphInfo>)IsolatedCompileContext.get().hand((Object)graph), graph.getNodeCount());
    }

    public void onSuccess(TruffleCompilable compilable, TruffleCompilationTask task, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo info, int tier) {
        IsolatedCompilationResultData data = (IsolatedCompilationResultData)StackValue.get(IsolatedCompilationResultData.class);
        data.setOriginalObjectHandle((CompilerHandle<TruffleCompilerListener.CompilationResultInfo>)IsolatedCompileContext.get().hand((Object)info));
        data.setTargetCodeSize(info.getTargetCodeSize());
        data.setTotalFrameSize(info.getTotalFrameSize());
        data.setExceptionHandlersCount(info.getExceptionHandlersCount());
        data.setInfopointsCount(info.getInfopointsCount());
        data.setMarksCount(info.getMarksCount());
        data.setDataPatchesCount(info.getDataPatchesCount());
        IsolatedTruffleCompilerEventForwarder.onSuccess0(IsolatedCompileContext.get().getClient(), this.contextHandle, (CompilerHandle<TruffleCompilerListener.GraphInfo>)IsolatedCompileContext.get().hand((Object)graph), graph.getNodeCount(), data, tier);
    }

    public void onFailure(TruffleCompilable compilable, String reason, boolean bailout, boolean permanentBailout, int tier, Supplier<String> lazyStackTrace) {
        try (CTypeConversion.CCharPointerHolder reasonCstr = CTypeConversion.toCString((CharSequence)reason);){
            IsolatedTruffleCompilerEventForwarder.onFailure0(IsolatedCompileContext.get().getClient(), this.contextHandle, reasonCstr.get(), bailout, permanentBailout, tier, (CompilerHandle<Supplier<String>>)(lazyStackTrace == null ? (CompilerHandle)IsolatedHandles.nullHandle() : IsolatedCompileContext.get().hand(lazyStackTrace)));
        }
    }

    public void onCompilationRetry(TruffleCompilable compilable, TruffleCompilationTask task) {
        IsolatedTruffleCompilerEventForwarder.onCompilationRetry0(IsolatedCompileContext.get().getClient(), this.contextHandle);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void onGraalTierFinished0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle, CompilerHandle<TruffleCompilerListener.GraphInfo> graphInfo, int nodeCount) {
        IsolatedEventContext context = (IsolatedEventContext)IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onGraalTierFinished(context.compilable, (TruffleCompilerListener.GraphInfo)new IsolatedGraphInfo(graphInfo, nodeCount));
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void onTruffleTierFinished0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle, CompilerHandle<TruffleCompilerListener.GraphInfo> graphInfo, int nodeCount) {
        IsolatedEventContext context = (IsolatedEventContext)IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onTruffleTierFinished(context.compilable, context.task, (TruffleCompilerListener.GraphInfo)new IsolatedGraphInfo(graphInfo, nodeCount));
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void onSuccess0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle, CompilerHandle<TruffleCompilerListener.GraphInfo> graphInfo, int nodeCount, IsolatedCompilationResultData resultData, int tier) {
        IsolatedEventContext context = (IsolatedEventContext)IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onSuccess(context.compilable, context.task, (TruffleCompilerListener.GraphInfo)new IsolatedGraphInfo(graphInfo, nodeCount), (TruffleCompilerListener.CompilationResultInfo)new IsolatedCompilationResultInfo(resultData), tier);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void onFailure0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle, CCharPointer reason, boolean bailout, boolean permanentBailout, int tier, CompilerHandle<Supplier<String>> lazyStackTraceHandle) {
        IsolatedEventContext context = (IsolatedEventContext)IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onFailure(context.compilable, CTypeConversion.toJavaString((CCharPointer)reason), bailout, permanentBailout, tier, (Supplier)(lazyStackTraceHandle.equal((ComparableWord)IsolatedHandles.nullHandle()) ? null : new IsolatedStringSupplier(lazyStackTraceHandle)));
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void onCompilationRetry0(ClientIsolateThread client, ClientHandle<IsolatedEventContext> contextHandle) {
        IsolatedEventContext context = (IsolatedEventContext)IsolatedCompileClient.get().unhand(contextHandle);
        context.listener.onCompilationRetry(context.compilable, context.task);
    }
}

