/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodeinfo.processor;

import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.graalvm.compiler.nodeinfo.processor.ElementException;
import org.graalvm.compiler.processor.AbstractProcessor;

public class GraphNodeVerifier {
    private final AbstractProcessor processor;
    private final TypeElement Input;
    private final TypeElement OptionalInput;
    private final TypeElement Successor;
    final TypeElement Node;
    private final TypeElement NodeInputList;
    private final TypeElement NodeSuccessorList;
    private final TypeElement object;

    public GraphNodeVerifier(AbstractProcessor processor) {
        this.processor = processor;
        this.Input = this.getTypeElement("org.graalvm.compiler.graph.Node.Input");
        this.OptionalInput = this.getTypeElement("org.graalvm.compiler.graph.Node.OptionalInput");
        this.Successor = this.getTypeElement("org.graalvm.compiler.graph.Node.Successor");
        this.Node = this.getTypeElement("org.graalvm.compiler.graph.Node");
        this.NodeInputList = this.getTypeElement("org.graalvm.compiler.graph.NodeInputList");
        this.NodeSuccessorList = this.getTypeElement("org.graalvm.compiler.graph.NodeSuccessorList");
        this.object = this.getTypeElement("java.lang.Object");
    }

    public TypeElement getTypeElement(String name) {
        return this.processor.getTypeElement(name);
    }

    public TypeElement getTypeElement(Class<?> cls) {
        return this.getTypeElement(cls.getName());
    }

    public TypeMirror getType(String name) {
        return this.getTypeElement(name).asType();
    }

    public boolean isAssignableWithErasure(Element from, Element to) {
        Types types = this.processor.env().getTypeUtils();
        TypeMirror fromType = types.erasure(from.asType());
        TypeMirror toType = types.erasure(to.asType());
        return types.isAssignable(fromType, toType);
    }

    private void scanFields(TypeElement node) {
        TypeElement currentClazz = node;
        do {
            for (VariableElement field : ElementFilter.fieldsIn(currentClazz.getEnclosedElements())) {
                boolean isSuccessor;
                Set<Modifier> modifiers = field.getModifiers();
                if (modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.TRANSIENT)) continue;
                List<? extends AnnotationMirror> annotations = field.getAnnotationMirrors();
                boolean isNonOptionalInput = this.findAnnotationMirror(annotations, this.Input) != null;
                boolean isOptionalInput = this.findAnnotationMirror(annotations, this.OptionalInput) != null;
                boolean bl = isSuccessor = this.findAnnotationMirror(annotations, this.Successor) != null;
                if (isNonOptionalInput || isOptionalInput) {
                    if (this.findAnnotationMirror(annotations, this.Successor) != null) {
                        throw new ElementException(field, "Field cannot be both input and successor", new Object[0]);
                    }
                    if (isNonOptionalInput && isOptionalInput) {
                        throw new ElementException(field, "Inputs must be either optional or non-optional", new Object[0]);
                    }
                    if (this.isAssignableWithErasure(field, this.NodeInputList)) {
                        if (modifiers.contains((Object)Modifier.FINAL)) {
                            throw new ElementException(field, "Input list field must not be final", new Object[0]);
                        }
                        if (!modifiers.contains((Object)Modifier.PUBLIC)) continue;
                        throw new ElementException(field, "Input list field must not be public", new Object[0]);
                    }
                    if (!this.isAssignableWithErasure(field, this.Node) && field.getKind() == ElementKind.INTERFACE) {
                        throw new ElementException(field, "Input field type must be an interface or assignable to Node", new Object[0]);
                    }
                    if (modifiers.contains((Object)Modifier.FINAL)) {
                        throw new ElementException(field, "Input field must not be final", new Object[0]);
                    }
                    if (!modifiers.contains((Object)Modifier.PUBLIC)) continue;
                    throw new ElementException(field, "Input field must not be public", new Object[0]);
                }
                if (isSuccessor) {
                    if (this.isAssignableWithErasure(field, this.NodeSuccessorList)) {
                        if (modifiers.contains((Object)Modifier.FINAL)) {
                            throw new ElementException(field, "Successor list field must not be final", new Object[0]);
                        }
                        if (!modifiers.contains((Object)Modifier.PUBLIC)) continue;
                        throw new ElementException(field, "Successor list field must not be public", new Object[0]);
                    }
                    if (!this.isAssignableWithErasure(field, this.Node)) {
                        throw new ElementException(field, "Successor field must be a Node type", new Object[0]);
                    }
                    if (modifiers.contains((Object)Modifier.FINAL)) {
                        throw new ElementException(field, "Successor field must not be final", new Object[0]);
                    }
                    if (!modifiers.contains((Object)Modifier.PUBLIC)) continue;
                    throw new ElementException(field, "Successor field must not be public", new Object[0]);
                }
                if (this.isAssignableWithErasure(field, this.Node) && !field.getSimpleName().contentEquals("Null")) {
                    throw new ElementException(field, "Node field must be annotated with @" + String.valueOf(this.Input.getSimpleName()) + ", @" + String.valueOf(this.OptionalInput.getSimpleName()) + " or @" + String.valueOf(this.Successor.getSimpleName()), new Object[0]);
                }
                if (this.isAssignableWithErasure(field, this.NodeInputList)) {
                    throw new ElementException(field, "NodeInputList field must be annotated with @" + String.valueOf(this.Input.getSimpleName()) + " or @" + String.valueOf(this.OptionalInput.getSimpleName()), new Object[0]);
                }
                if (this.isAssignableWithErasure(field, this.NodeSuccessorList)) {
                    throw new ElementException(field, "NodeSuccessorList field must be annotated with @" + String.valueOf(this.Successor.getSimpleName()), new Object[0]);
                }
                if (!modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.FINAL)) continue;
                throw new ElementException(field, "Data field must be final if public", new Object[0]);
            }
        } while (!this.isObject(this.getSuperType(currentClazz = this.getSuperType(currentClazz)).asType()));
    }

    private AnnotationMirror findAnnotationMirror(List<? extends AnnotationMirror> mirrors, TypeElement expectedAnnotationType) {
        for (AnnotationMirror annotationMirror : mirrors) {
            if (!this.sameType(annotationMirror.getAnnotationType(), expectedAnnotationType.asType())) continue;
            return annotationMirror;
        }
        return null;
    }

    private boolean isObject(TypeMirror type) {
        return this.sameType(this.object.asType(), type);
    }

    private boolean sameType(TypeMirror type1, TypeMirror type2) {
        return this.processor.env().getTypeUtils().isSameType(type1, type2);
    }

    private TypeElement getSuperType(TypeElement element) {
        if (element.getSuperclass() != null) {
            return this.processor.asTypeElement(element.getSuperclass());
        }
        return null;
    }

    void verify(TypeElement node) {
        this.scanFields(node);
        boolean foundValidConstructor = false;
        for (ExecutableElement constructor : ElementFilter.constructorsIn(node.getEnclosedElements())) {
            if (constructor.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) && !constructor.getModifiers().contains((Object)Modifier.PROTECTED)) {
                throw new ElementException(constructor, "Node class constructor must be public or protected", new Object[0]);
            }
            foundValidConstructor = true;
        }
        if (!foundValidConstructor) {
            throw new ElementException(node, "Node class must have at least one protected constructor", new Object[0]);
        }
    }
}

