/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.configwithorigins;

import com.oracle.svm.agent.configwithorigins.MethodInfoRecordKeeper;
import com.oracle.svm.agent.tracing.ConfigurationResultWriter;
import com.oracle.svm.agent.tracing.core.Tracer;
import com.oracle.svm.configure.config.conditional.MethodCallNode;
import com.oracle.svm.configure.config.conditional.MethodInfo;
import com.oracle.svm.configure.trace.TraceProcessor;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import org.graalvm.collections.EconomicMap;

public final class ConfigurationWithOriginsTracer
extends Tracer {
    protected final TraceProcessor processor;
    protected final MethodCallNode rootNode;
    protected final MethodInfoRecordKeeper methodInfoRecordKeeper;

    public ConfigurationWithOriginsTracer(TraceProcessor processor, MethodInfoRecordKeeper methodInfoRecordKeeper) {
        this.processor = processor;
        this.rootNode = MethodCallNode.createRoot();
        this.methodInfoRecordKeeper = methodInfoRecordKeeper;
    }

    @Override
    public void traceEntry(EconomicMap<String, Object> entry) {
        String tracer = (String)entry.get((Object)"tracer");
        if (tracer.equals("meta")) {
            this.processor.processEntry(entry, null);
        } else {
            assert (entry.containsKey((Object)"stack_trace"));
            JNIMethodId[] rawStackTrace = (JNIMethodId[])entry.removeKey((Object)"stack_trace");
            MethodInfo[] stackTrace = this.methodInfoRecordKeeper.getStackTraceInfo(rawStackTrace);
            EconomicMap<String, Object> transformedEntry = ConfigurationResultWriter.arraysToLists(entry);
            if (stackTrace == null) {
                this.traceEntry(this.rootNode, transformedEntry);
            } else {
                this.dispatchTraceEntry(stackTrace, transformedEntry);
            }
        }
    }

    public MethodCallNode getRootNode() {
        return this.rootNode;
    }

    private void dispatchTraceEntry(MethodInfo[] stackTrace, EconomicMap<String, Object> entry) {
        MethodCallNode currentNode = this.rootNode;
        for (int i = stackTrace.length - 1; i >= 0; --i) {
            MethodInfo nextMethodInfo = stackTrace[i];
            currentNode = currentNode.getOrCreateChild(nextMethodInfo);
        }
        this.traceEntry(currentNode, entry);
    }

    private void traceEntry(MethodCallNode node, EconomicMap<String, Object> entry) {
        this.processor.processEntry(entry, node.getConfiguration());
    }
}

