/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver.launcher.configuration;

import com.oracle.svm.driver.launcher.configuration.BundleConfigurationParser;
import com.oracle.svm.driver.launcher.json.BundleJSONParserException;
import java.net.URI;
import java.util.Map;

public class BundleEnvironmentParser
extends BundleConfigurationParser {
    private static final String environmentKeyField = "key";
    private static final String environmentValueField = "val";
    private final Map<String, String> environment;

    public BundleEnvironmentParser(Map<String, String> environment) {
        environment.clear();
        this.environment = environment;
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        for (Object rawEntry : BundleEnvironmentParser.asList(json, "Expected a list of environment variable objects")) {
            Map<String, Object> entry = BundleEnvironmentParser.asMap(rawEntry, "Expected a environment variable object");
            Object envVarKeyString = entry.get(environmentKeyField);
            if (envVarKeyString == null) {
                throw new BundleJSONParserException("Expected key-field in environment variable object");
            }
            Object envVarValueString = entry.get(environmentValueField);
            if (envVarValueString == null) {
                throw new BundleJSONParserException("Expected val-field in environment variable object");
            }
            this.environment.put(envVarKeyString.toString(), envVarValueString.toString());
        }
    }
}

