/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.loader;

import com.oracle.jipher.internal.common.Platform;
import com.oracle.jipher.internal.common.ToolkitProperties;
import com.oracle.jipher.internal.common.Version;
import com.oracle.jipher.internal.loader.LibraryLoader;
import com.oracle.jipher.internal.loader.SystemLoader;
import com.oracle.jipher.internal.openssl.JniOpenSsl;
import com.oracle.jipher.internal.openssl.OpenSsl;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.ProviderException;
import java.util.Random;

public class LibraryLoaderContext {
    private static final String TMP_DIR_PREFIX = "jiphertmp-" + Version.version() + "-";
    private final Random rand = new Random();
    private final Platform thisPlatform = Platform.getPlatform();
    private final Class loaderClass = this.getLoaderClass();

    private Class getLoaderClass() {
        try {
            return Class.forName("com.oracle.jipher.libs.LibraryResources");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Platform getPlatform() {
        return this.thisPlatform;
    }

    public String getLibTmpDir() {
        return ToolkitProperties.getJipherUserDir();
    }

    public boolean isJarWithLibraries() {
        return this.loaderClass != null && this.loaderClass.getClassLoader().getResource("libs") != null;
    }

    public boolean isLibInstallDirSpecified() {
        String configDir = ToolkitProperties.getJipherInstallDir();
        return configDir != null;
    }

    public String getLibInstallDir() {
        return ToolkitProperties.getJipherInstallDir();
    }

    public SystemLoader getSystemLoader() {
        return new SystemLoader();
    }

    OpenSsl configureOpenssl(String modulesPath, String configFile) {
        JniOpenSsl jossl = new JniOpenSsl();
        LibraryLoader.DEBUG.println("Configuring openssl to load FIPS module from dir: " + modulesPath);
        LibraryLoader.DEBUG.println("Configuring openssl using configuration in file: " + configFile);
        jossl.configure(modulesPath, configFile);
        return jossl;
    }

    public String getFipsModuleDir() {
        String[] javaLibPath;
        String dir = ToolkitProperties.getFipsModuleDir();
        if (dir != null) {
            return dir;
        }
        for (String path : javaLibPath = ToolkitProperties.getJavaLibraryPath().split(File.pathSeparator)) {
            if (!Files.exists(Paths.get(path, this.getPlatform().getFipsLibFile()), new LinkOption[0])) continue;
            return path;
        }
        throw new ProviderException("Fips module library not found in java.library.path");
    }

    public String genRandomDirName() {
        return TMP_DIR_PREFIX + Math.abs(this.rand.nextLong());
    }

    public String getRandomDirPrefix() {
        return TMP_DIR_PREFIX;
    }

    public ClassLoader getResourceClassLoader() {
        if (this.loaderClass == null) {
            throw new ProviderException("Resource loader not present.");
        }
        return this.loaderClass.getClassLoader();
    }
}

