/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.openssl;

import com.oracle.jipher.internal.openssl.EcCurve;
import com.oracle.jipher.internal.openssl.OpenSsl;
import com.oracle.jipher.internal.openssl.OpenSslException;
import com.oracle.jipher.internal.openssl.OsslFactory;
import com.oracle.jipher.internal.openssl.OsslObject;
import com.oracle.jipher.internal.openssl.PkeyType;
import java.security.InvalidKeyException;
import java.security.ProviderException;

public class Pkey
extends OsslObject {
    private final PkeyType type;

    public static void free(Pkey ... pkeys) {
        if (pkeys != null) {
            for (Pkey pk : pkeys) {
                if (pk == null) continue;
                pk.free();
            }
        }
    }

    Pkey(OpenSsl openssl, long ptr, PkeyType type) {
        super(new State(openssl, ptr));
        this.type = type;
    }

    Pkey createPub() {
        try {
            switch (this.type) {
                case RSA: {
                    return new Pkey(this.openssl, this.openssl.jphPkeyRsaPriv2Pub(this), this.type);
                }
                case EC: {
                    return new Pkey(this.openssl, this.openssl.jphPkeyEcPriv2Pub(this), this.type);
                }
                case DSA: {
                    return new Pkey(this.openssl, this.openssl.jphPkeyDsaPriv2Pub(this), this.type);
                }
                case DH: {
                    return new Pkey(this.openssl, this.openssl.jphPkeyDhPriv2Pub(this), this.type);
                }
            }
            throw new IllegalStateException("Not yet implemented for " + (Object)((Object)this.type));
        }
        catch (OpenSslException e) {
            throw new ProviderException(e);
        }
    }

    PkeyType getType() {
        return this.type;
    }

    public static Pkey newRsaPub(byte[] n, byte[] e) throws InvalidKeyException {
        try {
            OpenSsl openssl = OsslFactory.get();
            long ptr = openssl.jphPkeyNewRsaPub(n, e);
            return new Pkey(openssl, ptr, PkeyType.RSA);
        }
        catch (OpenSslException ex) {
            throw new InvalidKeyException(ex);
        }
    }

    public static Pkey newRsaPriv(byte[] n, byte[] e, byte[] d, byte[] p, byte[] q, byte[] expP, byte[] expQ, byte[] crtCoef) throws InvalidKeyException {
        try {
            OpenSsl openssl = OsslFactory.get();
            long ptr = openssl.jphPkeyNewRsaPriv(n, e, d, p, q, expP, expQ, crtCoef);
            return new Pkey(openssl, ptr, PkeyType.RSA);
        }
        catch (OpenSslException ex) {
            throw new InvalidKeyException(ex);
        }
    }

    public static Pkey newEcPub(EcCurve curve, byte[] pubPointX, byte[] pubPointY) throws InvalidKeyException {
        try {
            OpenSsl openssl = OsslFactory.get();
            long ptr = openssl.jphPkeyNewEcPub(curve.nid(), pubPointX, pubPointY);
            return new Pkey(openssl, ptr, PkeyType.EC);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public static Pkey newDsaPub(byte[] p, byte[] q, byte[] g, byte[] pub) throws InvalidKeyException {
        try {
            OpenSsl openssl = OsslFactory.get();
            long ptr = openssl.jphPkeyNewDsaPub(p, q, g, pub);
            return new Pkey(openssl, ptr, PkeyType.DSA);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public static Pkey newDsaPriv(byte[] p, byte[] q, byte[] g, byte[] prv) throws InvalidKeyException {
        try {
            OpenSsl openssl = OsslFactory.get();
            long ptr = openssl.jphPkeyNewDsaPriv(p, q, g, prv);
            return new Pkey(openssl, ptr, PkeyType.DSA);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public static Pkey newDhPub(byte[] p, byte[] q, byte[] g, byte[] pub) throws InvalidKeyException {
        try {
            OpenSsl openssl = OsslFactory.get();
            long ptr = openssl.jphPkeyNewDhPub(p, q, g, pub);
            return new Pkey(openssl, ptr, PkeyType.DH);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public static Pkey newDhPriv(byte[] p, byte[] q, byte[] g, byte[] prv) throws InvalidKeyException {
        try {
            OpenSsl openssl = OsslFactory.get();
            long ptr = openssl.jphPkeyNewDhPriv(p, q, g, prv);
            return new Pkey(openssl, ptr, PkeyType.DH);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public static Pkey newEcPriv(EcCurve curve, byte[] prv) throws InvalidKeyException {
        try {
            OpenSsl openssl = OsslFactory.get();
            long ptr = openssl.jphPkeyNewEcPriv(curve.nid(), prv);
            return new Pkey(openssl, ptr, PkeyType.EC);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public static Pkey newEcParams(EcCurve curve) throws ProviderException {
        try {
            OpenSsl openssl = OsslFactory.get();
            long ptr = openssl.jphPkeyNewEcParams(curve.nid());
            return new Pkey(openssl, ptr, PkeyType.EC);
        }
        catch (OpenSslException e) {
            throw new ProviderException(e);
        }
    }

    public static Pkey newDsaParams(byte[] p, byte[] q, byte[] g) {
        try {
            OpenSsl openssl = OsslFactory.get();
            long ptr = openssl.jphPkeyNewDsaParams(p, q, g);
            return new Pkey(openssl, ptr, PkeyType.DSA);
        }
        catch (OpenSslException e) {
            throw new ProviderException(e);
        }
    }

    public static Pkey newDhParams(byte[] p, byte[] q, byte[] g) {
        try {
            OpenSsl openssl = OsslFactory.get();
            long ptr = openssl.jphPkeyNewDhParams(p, q, g);
            return new Pkey(openssl, ptr, PkeyType.DH);
        }
        catch (OpenSslException e) {
            throw new ProviderException(e);
        }
    }

    public byte[][] getRsaKeyData() throws InvalidKeyException {
        if (this.type != PkeyType.RSA) {
            throw new IllegalStateException();
        }
        try {
            return this.openssl.jphPkeyRsaGetKey(this);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public byte[] getEcPrivateKey() throws InvalidKeyException {
        if (this.type != PkeyType.EC) {
            throw new IllegalStateException();
        }
        try {
            return this.openssl.jphPkeyGetEcPrivateKey(this);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public EcCurve getEcCurve() throws InvalidKeyException {
        if (this.type != PkeyType.EC) {
            throw new IllegalStateException();
        }
        try {
            EcCurve curve = EcCurve.byNid(this.openssl.jphPkeyGetEcGroupNid(this));
            if (curve == null) {
                throw new InvalidKeyException("Unsupported EC curve");
            }
            return curve;
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public byte[][] getEcPublicKey() throws InvalidKeyException {
        if (this.type != PkeyType.EC) {
            throw new IllegalStateException();
        }
        try {
            return this.openssl.jphPkeyGetEcPublicKey(this);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public byte[][] getDsaParams() throws InvalidKeyException {
        if (this.type != PkeyType.DSA) {
            throw new IllegalStateException();
        }
        try {
            return this.openssl.jphPkeyGetDsaParams(this);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public byte[] getDsaPublicKey() throws InvalidKeyException {
        if (this.type != PkeyType.DSA) {
            throw new IllegalStateException();
        }
        try {
            return this.openssl.jphPkeyGetDsaPublicKey(this);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public byte[] getDsaPrivateKey() throws InvalidKeyException {
        if (this.type != PkeyType.DSA) {
            throw new IllegalStateException();
        }
        try {
            return this.openssl.jphPkeyGetDsaPrivateKey(this);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public byte[][] getDhParams() throws InvalidKeyException {
        if (this.type != PkeyType.DH) {
            throw new IllegalStateException();
        }
        try {
            return this.openssl.jphPkeyGetDhParams(this);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public byte[] getDhPublicKey() throws InvalidKeyException {
        if (this.type != PkeyType.DH) {
            throw new IllegalStateException();
        }
        try {
            return this.openssl.jphPkeyGetDhPublicKey(this);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    public byte[] getDhPrivateKey() throws InvalidKeyException {
        if (this.type != PkeyType.DH) {
            throw new IllegalStateException();
        }
        try {
            return this.openssl.jphPkeyGetDhPrivateKey(this);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }

    static class State
    extends OsslObject.BaseState {
        State(OpenSsl openssl, long ptr) {
            super(openssl, ptr);
        }

        @Override
        void free(long ptr) {
            this.openssl.evpPkeyFree(ptr);
        }
    }
}

