/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.DerHelper;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.openssl.PkeyType;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

abstract class AsymKeyFactory
extends KeyFactorySpi {
    AsymKeyFactory() {
    }

    abstract PkeyType getPkeyType();

    abstract PrivateKey createPrivateKey(Pkey var1) throws InvalidKeyException;

    abstract PublicKey createPublicKey(Pkey var1, byte[] var2) throws InvalidKeyException;

    @Override
    protected abstract Key engineTranslateKey(Key var1) throws InvalidKeyException;

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] privDer = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            try {
                return this.generatePrivateInternal(privDer);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Could not decode private key", e);
            }
        }
        throw new InvalidKeySpecException("Cannot create private key from " + keySpec.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrivateKey generatePrivateInternal(byte[] privDer) throws InvalidKeyException {
        try {
            Pkey pkey = DerHelper.decodePrivate(privDer, this.getPkeyType());
            PrivateKey privateKey = this.createPrivateKey(pkey);
            return privateKey;
        }
        finally {
            Util.clearArray(privDer);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            byte[] pubDer = ((X509EncodedKeySpec)keySpec).getEncoded();
            try {
                return this.generatePublicInternal(pubDer);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Could not decode public key", e);
            }
        }
        throw new InvalidKeySpecException("Cannot create public key from " + keySpec.getClass());
    }

    PublicKey generatePublicInternal(byte[] pubDer) throws InvalidKeyException {
        Pkey pkey = DerHelper.decodePublic(pubDer, this.getPkeyType());
        return this.createPublicKey(pkey, pubDer);
    }

    Key translatePrivate(PrivateKey privKey) throws InvalidKeyException {
        return this.generatePrivateInternal(privKey.getEncoded());
    }

    Key translatePublic(PublicKey pubKey) throws InvalidKeyException {
        return this.generatePublicInternal(pubKey.getEncoded());
    }
}

