/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.fips.CryptoOp;
import com.oracle.jipher.internal.fips.Fips;
import com.oracle.jipher.internal.key.JceOsslKey;
import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.openssl.MdCtx;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.spi.AsymKeyFactory;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

abstract class DigestSignature
extends SignatureSpi {
    MdAlg md;
    MdCtx.Signature ctx;
    boolean isInitialized;
    private boolean initializedForSign;
    Pkey lastPkey;
    private AsymKeyFactory kf;

    DigestSignature(MdAlg md) {
        this.md = md;
        this.kf = this.getKeyFactory();
    }

    abstract AsymKeyFactory getKeyFactory();

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        Fips.enforcement().checkAlg(CryptoOp.SIGN, this.md == null ? null : this.md.getAlg());
        JceOsslKey prv = (JceOsslKey)this.kf.engineTranslateKey(privateKey);
        Fips.enforcement().checkStrength(CryptoOp.SIGN, prv);
        this.doInit(prv.getPkey(), true);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        Fips.enforcement().checkAlg(CryptoOp.VERIFY, this.md == null ? null : this.md.getAlg());
        JceOsslKey pub = (JceOsslKey)this.kf.engineTranslateKey(publicKey);
        Fips.enforcement().checkStrength(CryptoOp.VERIFY, pub);
        this.doInit(pub.getPkey(), false);
    }

    void doInit(Pkey pkey, boolean isSign) throws InvalidKeyException {
        this.cleanup();
        this.ctx = new MdCtx.Signature();
        if (isSign) {
            this.ctx.signInit(this.md, pkey);
        } else {
            this.ctx.verifyInit(this.md, pkey);
        }
        this.lastPkey = pkey;
        this.isInitialized = true;
        this.initializedForSign = isSign;
    }

    private void cleanup() {
        if (this.ctx != null) {
            this.ctx.free();
            this.ctx = null;
        }
    }

    private void initIfRequired() throws SignatureException {
        if (this.isInitialized && this.ctx == null) {
            try {
                this.doInit(this.lastPkey, this.initializedForSign);
            }
            catch (InvalidKeyException e) {
                throw new SignatureException(e);
            }
        }
    }

    @Override
    protected void engineUpdate(byte[] data, int off, int len) throws SignatureException {
        this.initIfRequired();
        if (this.initializedForSign) {
            this.ctx.signUpdate(data, off, len);
        } else {
            this.ctx.verifyUpdate(data, off, len);
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.engineUpdate(new byte[]{b}, 0, 1);
    }

    @Override
    public byte[] engineSign() throws SignatureException {
        this.initIfRequired();
        try {
            byte[] byArray = this.ctx.signFinal();
            return byArray;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean engineVerify(byte[] sigBytes, int offset, int len) throws SignatureException {
        this.initIfRequired();
        try {
            boolean bl = this.ctx.verifyFinal(sigBytes, offset, len);
            return bl;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        return this.engineVerify(sigBytes, 0, sigBytes.length);
    }
}

