/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.Rand;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class HmacKeyGenerator
extends KeyGeneratorSpi {
    private final int defaultKeyLenBytes;
    private final String algName;
    private int keyByteLen = -1;

    HmacKeyGenerator(String algName, int defaultKeyLen) {
        this.algName = algName;
        this.defaultKeyLenBytes = defaultKeyLen;
    }

    @Override
    protected void engineInit(int keyBits, SecureRandom secureRandom) {
        if (keyBits < 40) {
            throw new InvalidParameterException("Key length must be at least 40 bits.");
        }
        this.keyByteLen = (keyBits + 7) / 8;
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        this.keyByteLen = this.defaultKeyLenBytes;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Hmac key generation does not take any parameters");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        byte[] bytes = Rand.generate(this.keyByteLen == -1 ? this.defaultKeyLenBytes : this.keyByteLen);
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(bytes, this.algName);
            return secretKeySpec;
        }
        finally {
            Util.clearArray(bytes);
        }
    }

    public static class HmacSha512
    extends HmacKeyGenerator {
        public HmacSha512() {
            super("HmacSHA512", 64);
        }
    }

    public static class HmacSha384
    extends HmacKeyGenerator {
        public HmacSha384() {
            super("HmacSHA384", 48);
        }
    }

    public static class HmacSha256
    extends HmacKeyGenerator {
        public HmacSha256() {
            super("HmacSHA256", 32);
        }
    }

    public static class HmacSha224
    extends HmacKeyGenerator {
        public HmacSha224() {
            super("HmacSHA224", 28);
        }
    }

    public static class HmacSha1
    extends HmacKeyGenerator {
        public HmacSha1() {
            super("HmacSHA1", 20);
        }
    }
}

