/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.foreign.ABIs;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.graal.code.AssignedLocation;
import com.oracle.svm.core.util.VMError;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.internal.foreign.CABI;
import jdk.internal.foreign.abi.VMStorage;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class AbiUtils {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static AbiUtils create() {
        return switch (CABI.current()) {
            case CABI.SYS_V -> new ABIs.SysV();
            case CABI.WIN_64 -> new ABIs.Win64();
            default -> new ABIs.Unsupported(CABI.current().name());
        };
    }

    @Fold
    public static AbiUtils singleton() {
        return (AbiUtils)ImageSingletons.lookup(AbiUtils.class);
    }

    public abstract NativeEntryPointInfo makeNativeEntrypoint(FunctionDescriptor var1, Linker.Option ... var2);

    public abstract AssignedLocation[] toMemoryAssignment(VMStorage[] var1, boolean var2);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public final Adapter.AdaptationResult adapt(List<ValueNode> arguments, NativeEntryPointInfo nep) {
        return Adapter.adapt(this, this.generateAdaptations(nep), arguments, nep);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected List<Adapter.Adaptation> generateAdaptations(NativeEntryPointInfo nep) {
        ArrayList<Object> adaptations = new ArrayList<Object>(Collections.nCopies(nep.methodType().parameterCount(), null));
        int current = 0;
        if (nep.needsReturnBuffer()) {
            adaptations.set(current++, Adapter.check(Long.TYPE));
        }
        adaptations.set(current++, Adapter.extract(Adapter.Extracted.CallTarget, Long.TYPE));
        if (nep.capturesCallState()) {
            adaptations.set(current++, Adapter.extract(Adapter.Extracted.CaptureBufferAddress, Long.TYPE));
        }
        return adaptations;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public abstract void checkLibrarySupport();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public abstract Map<String, MemoryLayout> canonicalLayouts();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final class Adapter {
        private static final Adaptation NOOP = new Adaptation(){

            @Override
            public List<Class<?>> apply(Class<?> parameter) {
                return List.of(parameter);
            }

            @Override
            public List<AssignedLocation> apply(AssignedLocation parameter) {
                return List.of(parameter);
            }

            @Override
            public List<ValueNode> apply(ValueNode parameter, Map<Extracted, ValueNode> extractedArguments) {
                return List.of(parameter);
            }
        };

        private static boolean allEqual(int reference, int ... values) {
            return Arrays.stream(values).allMatch(v -> v == reference);
        }

        private Adapter() {
        }

        public static AdaptationResult adapt(AbiUtils self, List<Adaptation> adaptations, List<ValueNode> originalArguments, NativeEntryPointInfo nep) {
            int i;
            AssignedLocation[] originalAssignment = self.toMemoryAssignment(nep.parametersAssignment(), false);
            VMError.guarantee((boolean)Adapter.allEqual(adaptations.size(), originalArguments.size(), nep.methodType().parameterCount(), originalAssignment.length));
            EnumMap<Extracted, ValueNode> extractedArguments = new EnumMap<Extracted, ValueNode>(Extracted.class);
            ArrayList<ValueNode> arguments = new ArrayList<ValueNode>();
            ArrayList<AssignedLocation> assignment = new ArrayList<AssignedLocation>();
            ArrayList argumentTypes = new ArrayList();
            for (i = 0; i < adaptations.size(); ++i) {
                Adaptation adaptation = adaptations.get(i);
                if (adaptation == null) {
                    adaptation = NOOP;
                }
                arguments.addAll(adaptation.apply(originalArguments.get(i), extractedArguments));
                assignment.addAll(adaptation.apply(originalAssignment[i]));
                argumentTypes.addAll(adaptation.apply((Class<?>)nep.methodType().parameterType(i)));
                VMError.guarantee((boolean)Adapter.allEqual(arguments.size(), assignment.size(), argumentTypes.size()));
            }
            VMError.guarantee((boolean)extractedArguments.containsKey((Object)Extracted.CallTarget));
            VMError.guarantee((!nep.capturesCallState() || extractedArguments.containsKey((Object)Extracted.CaptureBufferAddress) ? 1 : 0) != 0);
            for (i = 0; i < arguments.size(); ++i) {
                VMError.guarantee((arguments.get(i) != null ? 1 : 0) != 0);
                VMError.guarantee((!((AssignedLocation)assignment.get(i)).isPlaceholder() || i == 0 && nep.needsReturnBuffer() ? 1 : 0) != 0);
            }
            return new AdaptationResult(extractedArguments, arguments, assignment, Arrays.stream(self.toMemoryAssignment(nep.returnsAssignment(), true)).toList(), MethodType.methodType(nep.methodType().returnType(), argumentTypes));
        }

        public static Adaptation check(Class<?> type) {
            return new CheckType(Objects.requireNonNull(type));
        }

        public static Adaptation extract(Extracted as, Class<?> type) {
            return new Extract(Objects.requireNonNull(as), Objects.requireNonNull(type));
        }

        public static Adaptation drop() {
            return Extract.DROP;
        }

        public static Adaptation reinterpret(JavaKind to) {
            return new Reinterpret(to);
        }

        public static enum Extracted {
            CallTarget,
            CaptureBufferAddress;

        }

        public static abstract class Adaptation {
            public abstract List<Class<?>> apply(Class<?> var1);

            public abstract List<AssignedLocation> apply(AssignedLocation var1);

            public abstract List<ValueNode> apply(ValueNode var1, Map<Extracted, ValueNode> var2);
        }

        public record AdaptationResult(Map<Extracted, ValueNode> extractedArguments, List<ValueNode> arguments, List<AssignedLocation> parametersAssignment, List<AssignedLocation> returnsAssignment, MethodType callType) {
            public ValueNode getArgument(Extracted id) {
                return this.extractedArguments.get((Object)id);
            }
        }

        private static final class CheckType
        extends Adaptation {
            private final Class<?> expected;

            private CheckType(Class<?> expected) {
                this.expected = expected;
            }

            @Override
            public List<Class<?>> apply(Class<?> parameter) {
                if (parameter != this.expected) {
                    throw new IllegalArgumentException("Expected type " + String.valueOf(this.expected) + ", got " + String.valueOf(parameter));
                }
                return List.of(parameter);
            }

            @Override
            public List<AssignedLocation> apply(AssignedLocation parameter) {
                return List.of(parameter);
            }

            @Override
            public List<ValueNode> apply(ValueNode parameter, Map<Extracted, ValueNode> extractedArguments) {
                return List.of(parameter);
            }
        }

        private static final class Extract
        extends Adaptation {
            private static Extract DROP = new Extract(null, null);
            private final Extracted as;
            private final Class<?> type;

            private Extract(Extracted as, Class<?> type) {
                this.as = as;
                this.type = type;
            }

            @Override
            public List<Class<?>> apply(Class<?> parameter) {
                if (this.type != null && parameter != this.type) {
                    throw new IllegalArgumentException("Expected type " + String.valueOf(this.type) + ", got " + String.valueOf(parameter));
                }
                return List.of();
            }

            @Override
            public List<AssignedLocation> apply(AssignedLocation parameter) {
                return List.of();
            }

            @Override
            public List<ValueNode> apply(ValueNode parameter, Map<Extracted, ValueNode> extractedArguments) {
                if (this.as != null) {
                    if (extractedArguments.containsKey((Object)this.as)) {
                        throw new IllegalStateException("%s was already extracted (%s).".formatted(new Object[]{this.as, extractedArguments.get((Object)this.as)}));
                    }
                    extractedArguments.put(this.as, parameter);
                }
                return List.of();
            }
        }

        private static final class Reinterpret
        extends Adaptation {
            private final JavaKind to;

            private Reinterpret(JavaKind to) {
                this.to = to;
            }

            @Override
            public List<Class<?>> apply(Class<?> parameter) {
                return List.of(this.to.toJavaClass());
            }

            @Override
            public List<AssignedLocation> apply(AssignedLocation parameter) {
                return List.of(parameter);
            }

            @Override
            public List<ValueNode> apply(ValueNode parameter, Map<Extracted, ValueNode> extractedArguments) {
                return List.of(ReinterpretNode.reinterpret((JavaKind)this.to, (ValueNode)parameter));
            }
        }
    }
}

