/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OrtAllocator;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtLoggingLevel;
import ai.onnxruntime.OrtProvider;
import ai.onnxruntime.OrtSession;
import java.io.IOException;
import java.util.EnumSet;
import java.util.logging.Logger;

public final class OrtEnvironment
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(OrtEnvironment.class.getName());
    public static final String DEFAULT_NAME = "ort-java";
    private static volatile OrtEnvironment INSTANCE;
    private static volatile OrtLoggingLevel curLogLevel;
    private static volatile String curLoggingName;
    final long nativeHandle;
    final OrtAllocator defaultAllocator;

    public static synchronized OrtEnvironment getEnvironment() {
        if (INSTANCE == null) {
            return OrtEnvironment.getEnvironment(OrtLoggingLevel.ORT_LOGGING_LEVEL_WARNING, DEFAULT_NAME);
        }
        return INSTANCE;
    }

    public static OrtEnvironment getEnvironment(String string) {
        return OrtEnvironment.getEnvironment(OrtLoggingLevel.ORT_LOGGING_LEVEL_WARNING, string);
    }

    public static OrtEnvironment getEnvironment(OrtLoggingLevel ortLoggingLevel) {
        return OrtEnvironment.getEnvironment(ortLoggingLevel, DEFAULT_NAME);
    }

    public static synchronized OrtEnvironment getEnvironment(OrtLoggingLevel ortLoggingLevel, String string) {
        if (INSTANCE == null) {
            try {
                INSTANCE = new OrtEnvironment(ortLoggingLevel, string);
                curLogLevel = ortLoggingLevel;
                curLoggingName = string;
            }
            catch (OrtException ortException) {
                throw new IllegalStateException("Failed to create OrtEnvironment", ortException);
            }
        } else if (ortLoggingLevel.getValue() != curLogLevel.getValue() || !string.equals(curLoggingName)) {
            logger.warning("Tried to change OrtEnvironment's logging level or name while a reference exists.");
        }
        return INSTANCE;
    }

    public static synchronized OrtEnvironment getEnvironment(OrtLoggingLevel ortLoggingLevel, String string, ThreadingOptions threadingOptions) {
        if (INSTANCE == null) {
            try {
                INSTANCE = new OrtEnvironment(ortLoggingLevel, string, threadingOptions);
                curLogLevel = ortLoggingLevel;
                curLoggingName = string;
            }
            catch (OrtException ortException) {
                throw new IllegalStateException("Failed to create OrtEnvironment", ortException);
            }
            return INSTANCE;
        }
        throw new IllegalStateException("Tried to specify the thread pool when creating an OrtEnvironment, but one already exists.");
    }

    private OrtEnvironment() throws OrtException {
        this(OrtLoggingLevel.ORT_LOGGING_LEVEL_WARNING, "java-default");
    }

    private OrtEnvironment(OrtLoggingLevel ortLoggingLevel, String string) throws OrtException {
        this.nativeHandle = OrtEnvironment.createHandle(OnnxRuntime.ortApiHandle, ortLoggingLevel.getValue(), string);
        this.defaultAllocator = new OrtAllocator(OrtEnvironment.getDefaultAllocator(OnnxRuntime.ortApiHandle), true);
        Runtime.getRuntime().addShutdownHook(new Thread(new OrtEnvCloser(OnnxRuntime.ortApiHandle, this.nativeHandle)));
    }

    private OrtEnvironment(OrtLoggingLevel ortLoggingLevel, String string, ThreadingOptions threadingOptions) throws OrtException {
        this.nativeHandle = OrtEnvironment.createHandle(OnnxRuntime.ortApiHandle, ortLoggingLevel.getValue(), string, threadingOptions.nativeHandle);
        this.defaultAllocator = new OrtAllocator(OrtEnvironment.getDefaultAllocator(OnnxRuntime.ortApiHandle), true);
        Runtime.getRuntime().addShutdownHook(new Thread(new OrtEnvCloser(OnnxRuntime.ortApiHandle, this.nativeHandle)));
    }

    public OrtSession createSession(String string) throws OrtException {
        return this.createSession(string, new OrtSession.SessionOptions());
    }

    public OrtSession createSession(String string, OrtSession.SessionOptions sessionOptions) throws OrtException {
        return this.createSession(string, this.defaultAllocator, sessionOptions);
    }

    OrtSession createSession(String string, OrtAllocator ortAllocator, OrtSession.SessionOptions sessionOptions) throws OrtException {
        return new OrtSession(this, string, ortAllocator, sessionOptions);
    }

    public OrtSession createSession(byte[] byArray, OrtSession.SessionOptions sessionOptions) throws OrtException {
        return this.createSession(byArray, this.defaultAllocator, sessionOptions);
    }

    public OrtSession createSession(byte[] byArray) throws OrtException {
        return this.createSession(byArray, new OrtSession.SessionOptions());
    }

    OrtSession createSession(byte[] byArray, OrtAllocator ortAllocator, OrtSession.SessionOptions sessionOptions) throws OrtException {
        return new OrtSession(this, byArray, ortAllocator, sessionOptions);
    }

    public void setTelemetry(boolean bl2) throws OrtException {
        OrtEnvironment.setTelemetry(OnnxRuntime.ortApiHandle, this.nativeHandle, bl2);
    }

    public String toString() {
        return "OrtEnvironment(name=" + curLoggingName + ",logLevel=" + (Object)((Object)curLogLevel) + ")";
    }

    public static EnumSet<OrtProvider> getAvailableProviders() {
        return OnnxRuntime.providers.clone();
    }

    private static native long createHandle(long var0, int var2, String var3) throws OrtException;

    private static native long createHandle(long var0, int var2, String var3, long var4) throws OrtException;

    private static native long getDefaultAllocator(long var0) throws OrtException;

    private static native void close(long var0, long var2) throws OrtException;

    private static native void setTelemetry(long var0, long var2, boolean var4) throws OrtException;

    @Override
    public void close() {
    }

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to load onnx-runtime library", iOException);
        }
    }

    private static final class OrtEnvCloser
    implements Runnable {
        private final long apiHandle;
        private final long nativeHandle;

        OrtEnvCloser(long l2, long l3) {
            this.apiHandle = l2;
            this.nativeHandle = l3;
        }

        @Override
        public void run() {
            try {
                OrtEnvironment.close(this.apiHandle, this.nativeHandle);
            }
            catch (OrtException ortException) {
                System.err.println("Error closing OrtEnvironment, " + ortException);
            }
        }
    }

    public static final class ThreadingOptions
    implements AutoCloseable {
        private final long nativeHandle = ThreadingOptions.createThreadingOptions(OnnxRuntime.ortApiHandle);
        private boolean closed = false;

        private void checkClosed() {
            if (this.closed) {
                throw new IllegalStateException("Trying to use a closed ThreadingOptions");
            }
        }

        @Override
        public void close() {
            if (this.closed) {
                throw new IllegalStateException("Trying to close a closed ThreadingOptions.");
            }
            this.closeThreadingOptions(OnnxRuntime.ortApiHandle, this.nativeHandle);
            this.closed = true;
        }

        public void setGlobalInterOpNumThreads(int n2) throws OrtException {
            this.checkClosed();
            if (n2 < 0) {
                throw new IllegalArgumentException("Number of threads must be non-negative.");
            }
            this.setGlobalInterOpNumThreads(OnnxRuntime.ortApiHandle, this.nativeHandle, n2);
        }

        public void setGlobalIntraOpNumThreads(int n2) throws OrtException {
            this.checkClosed();
            if (n2 < 0) {
                throw new IllegalArgumentException("Number of threads must be non-negative.");
            }
            this.setGlobalIntraOpNumThreads(OnnxRuntime.ortApiHandle, this.nativeHandle, n2);
        }

        public void setGlobalSpinControl(boolean bl2) throws OrtException {
            this.checkClosed();
            this.setGlobalSpinControl(OnnxRuntime.ortApiHandle, this.nativeHandle, bl2 ? 1 : 0);
        }

        public void setGlobalDenormalAsZero() throws OrtException {
            this.checkClosed();
            this.setGlobalDenormalAsZero(OnnxRuntime.ortApiHandle, this.nativeHandle);
        }

        private static native long createThreadingOptions(long var0);

        private native void setGlobalIntraOpNumThreads(long var1, long var3, int var5) throws OrtException;

        private native void setGlobalInterOpNumThreads(long var1, long var3, int var5) throws OrtException;

        private native void setGlobalSpinControl(long var1, long var3, int var5) throws OrtException;

        private native void setGlobalDenormalAsZero(long var1, long var3) throws OrtException;

        private native void closeThreadingOptions(long var1, long var3);

        static {
            try {
                OnnxRuntime.init();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to load onnx-runtime library", iOException);
            }
        }
    }
}

