/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.sboutlining.concat;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JavaLangSubstitutions;
import com.oracle.svm.enterprise.core.sboutlining.concat.SubstrateStringConcatHelper;
import jdk.internal.misc.Unsafe;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;
import org.graalvm.word.PointerBase;

public final class SubstrateSBConcatHelper {
    private static final Unsafe kV = Unsafe.getUnsafe();

    private SubstrateSBConcatHelper() {
    }

    private static long c(long l2) {
        if ((int)l2 >= 0) {
            return l2;
        }
        throw new OutOfMemoryError("Required length exceeds implementation limit");
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static LengthCoderAndCapacityStruct mix(LengthCoderAndCapacityStruct lengthCoderAndCapacityStruct, boolean bl2) {
        int n2 = bl2 ? 4 : 5;
        long l2 = SubstrateSBConcatHelper.c(lengthCoderAndCapacityStruct.getLengthCoder() + (long)n2);
        long l3 = a.a(lengthCoderAndCapacityStruct, n2, l2);
        lengthCoderAndCapacityStruct.setLengthCoder(l2);
        lengthCoderAndCapacityStruct.setCapacity(l3);
        return lengthCoderAndCapacityStruct;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static LengthCoderAndCapacityStruct mix(LengthCoderAndCapacityStruct lengthCoderAndCapacityStruct, byte by) {
        return SubstrateSBConcatHelper.mix(lengthCoderAndCapacityStruct, (int)by);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static LengthCoderAndCapacityStruct mix(LengthCoderAndCapacityStruct lengthCoderAndCapacityStruct, char c2) {
        long l2 = 1L;
        long l3 = SubstrateSBConcatHelper.c(lengthCoderAndCapacityStruct.getLengthCoder() + l2) | (SubstrateStringConcatHelper.Target_java_lang_StringLatin1.canEncode(c2) ? 0L : SubstrateStringConcatHelper.lC);
        long l4 = a.a(lengthCoderAndCapacityStruct, l2, l3);
        lengthCoderAndCapacityStruct.setLengthCoder(l3);
        lengthCoderAndCapacityStruct.setCapacity(l4);
        return lengthCoderAndCapacityStruct;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static LengthCoderAndCapacityStruct mix(LengthCoderAndCapacityStruct lengthCoderAndCapacityStruct, short s2) {
        return SubstrateSBConcatHelper.mix(lengthCoderAndCapacityStruct, (int)s2);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static LengthCoderAndCapacityStruct mix(LengthCoderAndCapacityStruct lengthCoderAndCapacityStruct, int n2) {
        long l2 = SubstrateStringConcatHelper.Target_java_lang_Integer.stringSize(n2);
        long l3 = SubstrateSBConcatHelper.c(lengthCoderAndCapacityStruct.getLengthCoder() + l2);
        long l4 = a.a(lengthCoderAndCapacityStruct, l2, l3);
        lengthCoderAndCapacityStruct.setLengthCoder(l3);
        lengthCoderAndCapacityStruct.setCapacity(l4);
        return lengthCoderAndCapacityStruct;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static LengthCoderAndCapacityStruct mix(LengthCoderAndCapacityStruct lengthCoderAndCapacityStruct, long l2) {
        long l3 = SubstrateStringConcatHelper.Target_java_lang_Long.stringSize(l2);
        long l4 = SubstrateSBConcatHelper.c(lengthCoderAndCapacityStruct.getLengthCoder() + l3);
        long l5 = a.a(lengthCoderAndCapacityStruct, l3, l4);
        lengthCoderAndCapacityStruct.setLengthCoder(l4);
        lengthCoderAndCapacityStruct.setCapacity(l5);
        return lengthCoderAndCapacityStruct;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static LengthCoderAndCapacityStruct mix(LengthCoderAndCapacityStruct lengthCoderAndCapacityStruct, String string) {
        long l2 = string.length();
        long l3 = lengthCoderAndCapacityStruct.getLengthCoder() + (long)string.length();
        if (JavaLangSubstitutions.StringUtil.coder((String)string) == SubstrateStringConcatHelper.a.lF) {
            l3 |= SubstrateStringConcatHelper.lC;
        }
        l3 = SubstrateSBConcatHelper.c(l3);
        long l4 = a.a(lengthCoderAndCapacityStruct, l2, l3);
        lengthCoderAndCapacityStruct.setLengthCoder(l3);
        lengthCoderAndCapacityStruct.setCapacity(l4);
        return lengthCoderAndCapacityStruct;
    }

    @AlwaysInline(value="@ForceInline in JDK")
    @com.oracle.svm.enterprise.core.annotate.a
    static byte[] newArray(LengthCoderAndCapacityStruct lengthCoderAndCapacityStruct) {
        byte by = (byte)(lengthCoderAndCapacityStruct.getLengthCoder() >> 32);
        int n2 = (int)lengthCoderAndCapacityStruct.getCapacity();
        return (byte[])kV.allocateUninitializedArray(Byte.TYPE, n2 << by);
    }

    static byte d(long l2) {
        if (l2 == SubstrateStringConcatHelper.lB) {
            return SubstrateStringConcatHelper.a.lG;
        }
        if (l2 == SubstrateStringConcatHelper.lC) {
            return SubstrateStringConcatHelper.a.lF;
        }
        throw new InternalError("Storage is not completely initialized, " + (int)l2 + " bytes left");
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static StringBuilder newStringBuilder(byte[] byArray, long l2, long l3) {
        Target_java_lang_AbstractStringBuilder target_java_lang_AbstractStringBuilder;
        try {
            target_java_lang_AbstractStringBuilder = (Target_java_lang_AbstractStringBuilder)SubstrateUtil.cast((Object)kV.allocateInstance(StringBuilder.class), Target_java_lang_AbstractStringBuilder.class);
        }
        catch (Throwable throwable) {
            throw GraalError.shouldNotReachHere((Throwable)throwable);
        }
        target_java_lang_AbstractStringBuilder.value = byArray;
        target_java_lang_AbstractStringBuilder.coder = SubstrateSBConcatHelper.d(l2);
        target_java_lang_AbstractStringBuilder.count = (int)l3;
        return (StringBuilder)SubstrateUtil.cast((Object)target_java_lang_AbstractStringBuilder, StringBuilder.class);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static StringBuffer newStringBuffer(byte[] byArray, long l2, long l3) {
        Target_java_lang_AbstractStringBuilder target_java_lang_AbstractStringBuilder;
        try {
            target_java_lang_AbstractStringBuilder = (Target_java_lang_AbstractStringBuilder)SubstrateUtil.cast((Object)kV.allocateInstance(StringBuffer.class), Target_java_lang_AbstractStringBuilder.class);
        }
        catch (Throwable throwable) {
            throw GraalError.shouldNotReachHere((Throwable)throwable);
        }
        target_java_lang_AbstractStringBuilder.value = byArray;
        target_java_lang_AbstractStringBuilder.coder = SubstrateSBConcatHelper.d(l2);
        target_java_lang_AbstractStringBuilder.count = (int)l3;
        return (StringBuffer)SubstrateUtil.cast((Object)target_java_lang_AbstractStringBuilder, StringBuffer.class);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long getIndexCoder(LengthCoderAndCapacityStruct lengthCoderAndCapacityStruct) {
        return lengthCoderAndCapacityStruct.getLengthCoder();
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long getCount(LengthCoderAndCapacityStruct lengthCoderAndCapacityStruct) {
        return lengthCoderAndCapacityStruct.getLengthCoder() & NumUtil.getNbitNumberLong((int)32);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static LengthCoderAndCapacityStruct initializeCoderAndCapacity(LengthCoderAndCapacityStruct lengthCoderAndCapacityStruct, int n2) {
        long l2 = SubstrateStringConcatHelper.ci();
        lengthCoderAndCapacityStruct.setLengthCoder(l2);
        lengthCoderAndCapacityStruct.setCapacity(n2);
        return lengthCoderAndCapacityStruct;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    public static int validateCapacity(int n2) {
        if (n2 < 0) {
            throw new NegativeArraySizeException(Integer.toString(n2));
        }
        return n2;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    public static <T> T ensureNonNull(T t2) {
        if (t2 == null) {
            throw new NullPointerException();
        }
        return t2;
    }

    @RawStructure
    public static interface LengthCoderAndCapacityStruct
    extends PointerBase {
        @RawField
        @UniqueLocationIdentity
        public long getLengthCoder();

        @RawField
        @UniqueLocationIdentity
        public void setLengthCoder(long var1);

        @RawField
        @UniqueLocationIdentity
        public long getCapacity();

        @RawField
        @UniqueLocationIdentity
        public void setCapacity(long var1);
    }

    public static final class a {
        private static final int kW = 0x7FFFFFF7;

        @com.oracle.svm.enterprise.core.annotate.a
        public static int initialCapacityFor(String string) {
            int n2 = string.length();
            int n3 = n2 < 0x7FFFFFEF ? n2 + 16 : Integer.MAX_VALUE;
            return n3;
        }

        public static int cf() {
            return 16;
        }

        private static long a(LengthCoderAndCapacityStruct lengthCoderAndCapacityStruct, long l2, long l3) {
            int n2 = (int)lengthCoderAndCapacityStruct.getLengthCoder();
            int n3 = NumUtil.safeToInt((long)lengthCoderAndCapacityStruct.getCapacity());
            int n4 = l3 < SubstrateStringConcatHelper.lC ? 0 : 1;
            return a.a(n3, n2, (int)l2, n4);
        }

        private static long a(int n2, int n3, int n4, int n5) {
            int n6 = n3 + n4;
            if (n6 - n2 > 0) {
                return a.b(n2, n3, n4, n5);
            }
            return n2;
        }

        private static int b(int n2, int n3, int n4, int n5) {
            int n6 = n2;
            int n7 = (n6 << 1) + 2;
            int n8 = n3 + n4;
            if (n7 - n8 < 0) {
                n7 = n8;
            }
            int n9 = 0x7FFFFFF7 >> n5;
            return n7 <= 0 || n9 - n7 < 0 ? a.a(n8, n5) : n7;
        }

        private static int a(int n2, int n3) {
            int n4 = 0x7FFFFFF7 >> n3;
            int n5 = Integer.MAX_VALUE >> n3;
            if (n5 - n2 < 0) {
                throw new OutOfMemoryError("Required length exceeds implementation limit");
            }
            return n2 > n4 ? n2 : n4;
        }
    }

    @TargetClass(className="java.lang.AbstractStringBuilder")
    private static final class Target_java_lang_AbstractStringBuilder {
        @Alias
        byte[] value;
        @Alias
        byte coder;
        @Alias
        int count;

        private Target_java_lang_AbstractStringBuilder() {
        }
    }
}

