/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1.graal;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.nodes.SubstrateCompressionNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.Target_java_lang_ref_Reference;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.enterprise.gc.g1.e;
import java.util.Map;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.gc.G1ArrayRangePostWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1ArrayRangePreWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1PostWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1PreWriteBarrier;
import org.graalvm.compiler.nodes.gc.G1ReferentFieldReadBarrier;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.gc.G1WriteBarrierSnippets;
import org.graalvm.compiler.replacements.gc.WriteBarrierSnippets;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

public final class j
extends G1WriteBarrierSnippets {
    private static final MetaAccessProvider oU = null;
    private static final SnippetRuntime.SubstrateForeignCallDescriptor oV = SnippetRuntime.findForeignCall(j.class, (String)"preWriteBarrierStub", (boolean)true, (LocationIdentity[])KILLED_PRE_WRITE_BARRIER_STUB_LOCATIONS);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor oW = SnippetRuntime.findForeignCall(j.class, (String)"postWriteBarrierStub", (boolean)true, (LocationIdentity[])KILLED_POST_WRITE_BARRIER_STUB_LOCATIONS);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor oX = SnippetRuntime.findForeignCall(j.class, (String)"verifyOopStub", (boolean)true, (LocationIdentity[])new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor oY = SnippetRuntime.findForeignCall(j.class, (String)"validateObjectStub", (boolean)true, (LocationIdentity[])new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor oZ = SnippetRuntime.findForeignCall(j.class, (String)"logPrintf", (boolean)true, (LocationIdentity[])new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] pa = new SnippetRuntime.SubstrateForeignCallDescriptor[]{oV, oW, oX, oY, oZ};

    public static void registerForeignCalls(SubstrateForeignCallsProvider substrateForeignCallsProvider) {
        substrateForeignCallsProvider.register(pa);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true, fullyUninterruptible=true)
    @Uninterruptible(reason="calls into native code with no transition")
    private static void preWriteBarrierStub(Object object) {
        com.oracle.svm.enterprise.gc.g1.nativelib.b.preWriteBarrierStub(Word.objectToUntrackedPointer((Object)object));
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true, fullyUninterruptible=true)
    @Uninterruptible(reason="calls into native code with no transition")
    private static void postWriteBarrierStub(Word word) {
        com.oracle.svm.enterprise.gc.g1.nativelib.b.postWriteBarrierStub(word);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true, fullyUninterruptible=true)
    @Uninterruptible(reason="calls into native code with no transition")
    private static void verifyOopStub(Object object) {
        com.oracle.svm.enterprise.gc.g1.nativelib.b.verifyOop(Word.objectToUntrackedPointer((Object)object));
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true, fullyUninterruptible=true)
    @Uninterruptible(reason="calls into native code with no transition")
    private static void validateObjectStub(Word word, Word word2) {
        com.oracle.svm.enterprise.gc.g1.nativelib.b.validateObject(word, word2);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true, fullyUninterruptible=true)
    @Uninterruptible(reason="calls into native code with no transition")
    private static void logPrintf(Word word, long l2, long l3, long l4) {
        com.oracle.svm.enterprise.gc.g1.nativelib.b.logPrintf(word, l2, l3, l4);
    }

    protected Word getThread() {
        return (Word)e.mu.getAddress();
    }

    protected int wordSize() {
        return ConfigurationValues.getTarget().wordSize;
    }

    protected long objectArrayIndexScale() {
        return ReplacementsUtil.arrayIndexScale((MetaAccessProvider)oU, (JavaKind)JavaKind.Object);
    }

    protected int satbQueueMarkingActiveOffset() {
        return com.oracle.svm.enterprise.gc.g1.b.satbQueueMarkingActiveOffset();
    }

    protected int satbQueueBufferOffset() {
        return com.oracle.svm.enterprise.gc.g1.b.satbQueueBufferOffset();
    }

    protected int satbQueueIndexOffset() {
        return com.oracle.svm.enterprise.gc.g1.b.satbQueueIndexOffset();
    }

    protected int cardQueueBufferOffset() {
        return com.oracle.svm.enterprise.gc.g1.b.cardQueueBufferOffset();
    }

    protected int cardQueueIndexOffset() {
        return com.oracle.svm.enterprise.gc.g1.b.cardQueueIndexOffset();
    }

    protected byte dirtyCardValue() {
        return com.oracle.svm.enterprise.gc.g1.b.dirtyCardValue();
    }

    protected byte youngCardValue() {
        return com.oracle.svm.enterprise.gc.g1.b.youngCardValue();
    }

    protected Word cardTableAddress(Pointer pointer) {
        return (Word)WordFactory.unsigned((long)e.ct()).add(pointer.unsignedShiftRight(com.oracle.svm.enterprise.gc.g1.b.cardTableShift()));
    }

    protected int logOfHeapRegionGrainBytes() {
        return com.oracle.svm.enterprise.gc.g1.b.logOfHeapRegionGrainBytes();
    }

    protected ForeignCallDescriptor preWriteBarrierCallDescriptor() {
        return oV;
    }

    protected ForeignCallDescriptor postWriteBarrierCallDescriptor() {
        return oW;
    }

    protected boolean verifyOops() {
        return false;
    }

    protected boolean verifyBarrier() {
        return ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED;
    }

    protected long gcTotalCollectionsAddress() {
        return e.cu();
    }

    protected ForeignCallDescriptor verifyOopCallDescriptor() {
        return oX;
    }

    protected ForeignCallDescriptor validateObjectCallDescriptor() {
        return oY;
    }

    protected ForeignCallDescriptor printfCallDescriptor() {
        return oZ;
    }

    @Fold
    protected static ResolvedJavaType getReferenceType(@Fold.InjectedParameter MetaAccessProvider metaAccessProvider) {
        return metaAccessProvider.lookupJavaType(Target_java_lang_ref_Reference.class);
    }

    private static final class a
    extends G1WriteBarrierSnippets.G1WriteBarrierLowerer {
        private final CompressEncoding pb = ReferenceAccess.singleton().haveCompressedReferences() ? (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class) : null;

        a(SnippetCounter.Group.Factory factory) {
            super(factory);
        }

        public ValueNode uncompress(ValueNode valueNode) {
            assert (this.pb != null);
            return SubstrateCompressionNode.uncompress((StructuredGraph)valueNode.graph(), (ValueNode)valueNode, (CompressEncoding)this.pb);
        }
    }

    public static class com.oracle.svm.enterprise.gc.g1.graal.j$b
    extends SubstrateTemplates {
        private final SnippetTemplate.SnippetInfo pc;
        private final SnippetTemplate.SnippetInfo pd;
        private final SnippetTemplate.SnippetInfo pe;
        private final SnippetTemplate.SnippetInfo pf;
        private final SnippetTemplate.SnippetInfo pg;
        private final G1WriteBarrierSnippets.G1WriteBarrierLowerer ph;

        public com.oracle.svm.enterprise.gc.g1.graal.j$b(OptionValues optionValues, SnippetCounter.Group.Factory factory, Providers providers) {
            super(optionValues, providers);
            this.ph = new com.oracle.svm.enterprise.gc.g1.graal.j$a(factory);
            j j2 = new j();
            this.pc = this.snippet(providers, G1WriteBarrierSnippets.class, "g1PreWriteBarrier", (Object)j2, new Object[]{G1WriteBarrierSnippets.SATB_QUEUE_LOG_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_BUFFER_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_MARKING_ACTIVE_LOCATION, com.oracle.svm.enterprise.gc.g1.e.mw});
            this.pd = this.snippet(providers, G1WriteBarrierSnippets.class, "g1ReferentReadBarrier", (Object)j2, new Object[]{G1WriteBarrierSnippets.SATB_QUEUE_LOG_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_BUFFER_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_MARKING_ACTIVE_LOCATION, com.oracle.svm.enterprise.gc.g1.e.mw});
            this.pe = this.snippet(providers, G1WriteBarrierSnippets.class, "g1PostWriteBarrier", (Object)j2, new Object[]{WriteBarrierSnippets.GC_CARD_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_LOG_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_BUFFER_LOCATION, com.oracle.svm.enterprise.gc.g1.e.mw, com.oracle.svm.enterprise.gc.g1.e.mv});
            this.pf = this.snippet(providers, G1WriteBarrierSnippets.class, "g1ArrayRangePreWriteBarrier", (Object)j2, new Object[]{G1WriteBarrierSnippets.SATB_QUEUE_LOG_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_BUFFER_LOCATION, G1WriteBarrierSnippets.SATB_QUEUE_MARKING_ACTIVE_LOCATION, com.oracle.svm.enterprise.gc.g1.e.mw});
            this.pg = this.snippet(providers, G1WriteBarrierSnippets.class, "g1ArrayRangePostWriteBarrier", (Object)j2, new Object[]{WriteBarrierSnippets.GC_CARD_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_LOG_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_INDEX_LOCATION, G1WriteBarrierSnippets.CARD_QUEUE_BUFFER_LOCATION, com.oracle.svm.enterprise.gc.g1.e.mv});
        }

        public void registerLowerings(Map<Class<? extends Node>, NodeLoweringProvider<?>> map) {
            d d2 = new d();
            map.put(G1PreWriteBarrier.class, d2);
            c c2 = new c();
            map.put(G1PostWriteBarrier.class, c2);
            e e2 = new e();
            map.put(G1ReferentFieldReadBarrier.class, e2);
            b b2 = new b();
            map.put(G1ArrayRangePreWriteBarrier.class, b2);
            a a2 = new a();
            map.put(G1ArrayRangePostWriteBarrier.class, a2);
        }

        private class d
        implements NodeLoweringProvider<G1PreWriteBarrier> {
            private d() {
            }

            public void a(G1PreWriteBarrier g1PreWriteBarrier, LoweringTool loweringTool) {
                b.this.ph.lower((SnippetTemplate.AbstractTemplates)b.this, b.this.pc, g1PreWriteBarrier, loweringTool);
            }

            public /* synthetic */ void lower(Node node, LoweringTool loweringTool) {
                this.a((G1PreWriteBarrier)node, loweringTool);
            }
        }

        private class c
        implements NodeLoweringProvider<G1PostWriteBarrier> {
            private c() {
            }

            public void a(G1PostWriteBarrier g1PostWriteBarrier, LoweringTool loweringTool) {
                b.this.ph.lower((SnippetTemplate.AbstractTemplates)b.this, b.this.pe, g1PostWriteBarrier, loweringTool);
            }

            public /* synthetic */ void lower(Node node, LoweringTool loweringTool) {
                this.a((G1PostWriteBarrier)node, loweringTool);
            }
        }

        private class e
        implements NodeLoweringProvider<G1ReferentFieldReadBarrier> {
            private e() {
            }

            public void a(G1ReferentFieldReadBarrier g1ReferentFieldReadBarrier, LoweringTool loweringTool) {
                b.this.ph.lower((SnippetTemplate.AbstractTemplates)b.this, b.this.pd, g1ReferentFieldReadBarrier, loweringTool);
            }

            public /* synthetic */ void lower(Node node, LoweringTool loweringTool) {
                this.a((G1ReferentFieldReadBarrier)node, loweringTool);
            }
        }

        private class b
        implements NodeLoweringProvider<G1ArrayRangePreWriteBarrier> {
            private b() {
            }

            public void a(G1ArrayRangePreWriteBarrier g1ArrayRangePreWriteBarrier, LoweringTool loweringTool) {
                b.this.ph.lower((SnippetTemplate.AbstractTemplates)b.this, b.this.pf, g1ArrayRangePreWriteBarrier, loweringTool);
            }

            public /* synthetic */ void lower(Node node, LoweringTool loweringTool) {
                this.a((G1ArrayRangePreWriteBarrier)node, loweringTool);
            }
        }

        private class a
        implements NodeLoweringProvider<G1ArrayRangePostWriteBarrier> {
            private a() {
            }

            public void a(G1ArrayRangePostWriteBarrier g1ArrayRangePostWriteBarrier, LoweringTool loweringTool) {
                b.this.ph.lower((SnippetTemplate.AbstractTemplates)b.this, b.this.pg, g1ArrayRangePostWriteBarrier, loweringTool);
            }

            public /* synthetic */ void lower(Node node, LoweringTool loweringTool) {
                this.a((G1ArrayRangePostWriteBarrier)node, loweringTool);
            }
        }
    }
}

