/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.enterprise.hosted.pgo.features.PGOFeature;
import com.oracle.svm.hosted.ByteFormattingUtil;
import com.oracle.svm.hosted.Log4ShellFeature;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.ProgressReporterFeature;
import com.oracle.svm.hosted.ProgressReporterJsonHelper;
import java.io.ObjectInputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@AutomaticallyRegisteredFeature
public class h
extends ProgressReporterFeature {
    private static boolean pT;

    public static boolean f() {
        return pT;
    }

    public static void e(boolean bl2) {
        pT = bl2;
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        h.e(afterAnalysisAccess.isReachable(ObjectInputStream.class));
    }

    protected void appendGraalSuffix(ProgressReporter.DirectPrinter directPrinter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (com.oracle.svm.enterprise.hosted.profiling.features.a.gg()) {
            arrayList.add("instrument");
        }
        if (PGOFeature.isPGOEnabled()) {
            arrayList.add("user-provided");
        }
        if (com.oracle.svm.enterprise.hosted.ml.features.provider.a.ep()) {
            arrayList.add("ML-inferred");
        }
        if (!arrayList.isEmpty()) {
            this.reporter.recordJsonMetric((ProgressReporterJsonHelper.JsonMetric)ProgressReporterJsonHelper.GeneralInfo.GRAAL_COMPILER_PGO, arrayList);
        }
        String string = arrayList.isEmpty() ? "off" : String.join((CharSequence)"+", arrayList);
        ((ProgressReporter.DirectPrinter)directPrinter.a(", ").doclink("PGO", "#recommendation-pgo")).a(": ").a(string);
    }

    private ProgressReporter.DirectPrinter dj() {
        return this.reporter.l();
    }

    public void afterBreakdowns() {
        this.dk();
        this.dl();
    }

    private void dk() {
        ProgressReporter.CenteredTextPrinter centeredTextPrinter = (ProgressReporter.CenteredTextPrinter)this.reporter.centered().dim();
        if (ImageSingletons.contains(a.class)) {
            a a2 = (a)ImageSingletons.lookup(a.class);
            Path path = a2.b();
            ((ProgressReporter.CenteredTextPrinter)((ProgressReporter.CenteredTextPrinter)centeredTextPrinter.a("For more details, open '")).link(path, true)).a("'.");
        } else {
            centeredTextPrinter.a("Use '-H:+BuildReport' to create a report with more details.");
        }
        centeredTextPrinter.reset();
        centeredTextPrinter.flushln();
    }

    private void dl() {
        Object object;
        this.dj().printLineSeparator();
        ((ProgressReporter.DirectPrinter)((ProgressReporter.DirectPrinter)this.dj().yellowBold()).a("Security report:").reset()).println();
        ((ProgressReporter.DirectPrinter)this.dj().a(" - Binary").a(pT ? " includes " : " does not include ").doclink("Java deserialization", "#glossary-deserialization")).a(".").println();
        if (ImageSingletons.contains(b.class)) {
            object = (b)ImageSingletons.lookup(b.class);
            ((ProgressReporter.DirectPrinter)((ProgressReporter.DirectPrinter)this.dj().a(" - ").doclink("Embedded SBOM", "#glossary-embedded-sbom")).a(" contains %s component(s) and is %s in size.", new Object[]{object.dq(), ByteFormattingUtil.bytesToHuman((long)object.dp())})).println();
        } else {
            ((ProgressReporter.DirectPrinter)this.dj().a(" - Use '--enable-sbom' to ").doclink("embed a Software Bill of Materials (SBOM)", "#glossary-embedded-sbom")).a(" in the binary.").println();
        }
        if (SubstrateControlFlowIntegrity.enabled()) {
            ((ProgressReporter.DirectPrinter)this.dj().a(" - ").doclink("Backwards-edge control-flow integrity (CFI)", "#glossary-backwards-edge-cfi")).a(" enforced within the binary using pointer authentication codes (PAC).").println();
        }
        if (ImageSingletons.contains(Log4ShellFeature.class) && (object = ((Log4ShellFeature)ImageSingletons.lookup(Log4ShellFeature.class)).getUserWarning()) != null) {
            ((ProgressReporter.DirectPrinter)((ProgressReporter.DirectPrinter)((ProgressReporter.DirectPrinter)this.dj().red()).a(" - %s", new Object[]{object})).reset()).println();
        }
    }

    public void createAdditionalArtifactsOnSuccess(BuildArtifacts buildArtifacts) {
        if (ImageSingletons.contains(a.class)) {
            ((a)ImageSingletons.lookup(a.class)).a(buildArtifacts);
        }
    }

    protected List<ProgressReporterFeature.UserRecommendation> getRecommendations() {
        ArrayList<ProgressReporterFeature.UserRecommendation> arrayList = new ArrayList<ProgressReporterFeature.UserRecommendation>();
        arrayList.add(new ProgressReporterFeature.UserRecommendation("G1GC", "Use the G1 GC ('--gc=G1') for improved latency and throughput.", h::dm));
        arrayList.add(new ProgressReporterFeature.UserRecommendation("PGO", "Use Profile-Guided Optimizations ('--pgo') for improved throughput.", () -> !PGOFeature.isPGOEnabled()));
        arrayList.addAll(super.getRecommendations());
        arrayList.add(new ProgressReporterFeature.UserRecommendation("QBM", "Use the quick build mode ('-Ob') to speed up builds during development.", () -> !SubstrateOptions.useEconomyCompilerConfig()));
        return arrayList;
    }

    private static boolean dm() {
        return !SubstrateOptions.UseSerialGC.hasBeenSet() && Platform.includedIn(Platform.LINUX_AMD64.class);
    }

    public static interface a {
        public Path b();

        public void a(BuildArtifacts var1);
    }

    public static interface b {
        public int dp();

        public int dq();
    }
}

