/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.graph.NodeSourcePosition;

public class d<D> {
    private final Map<AnalysisMethod, c> tV = new HashMap<AnalysisMethod, c>();
    private final Supplier<D> tW;
    private final long tX;
    private final double tY;
    private static final String[] tZ = new String[]{"java.lang.Thread.sleep", "java.util.concurrent.locks.LockSupport.unpark", "java.util.concurrent.locks.ReentrantLock.tryLock", "jdk.internal.misc.Unsafe.park", "jdk.internal.misc.Unsafe.unpark", "java.util.concurrent.locks.LockSupport.setBlocker", "java.util.concurrent.locks.ReentrantLock$Sync.lock"};

    public d(PGOProfilesLookup pGOProfilesLookup, Supplier<D> supplier) {
        this.tW = supplier;
        Map map = pGOProfilesLookup.getSamples().orElseGet(HashMap::new);
        for (Map.Entry entry : map.entrySet()) {
            if (d.m((List)entry.getKey())) continue;
            a a2 = a.n((List)entry.getKey());
            com.oracle.svm.enterprise.profiling.metadata.codepositions.d d2 = a2.eS();
            c c2 = this.tV.computeIfAbsent(d2.fa(), analysisMethod -> new c((AnalysisMethod)analysisMethod));
            Optional<long[]> optional = pGOProfilesLookup.getSample((com.oracle.svm.enterprise.profiling.metadata.cctree.c)entry.getValue());
            optional.ifPresent(lArray -> c2.a(a2, (long[])lArray));
        }
        this.tX = this.eP();
        this.tY = (Double)com.oracle.svm.enterprise.hosted.cai.b.CAIHotContextsRatio.getValue(HostedOptionValues.singleton());
    }

    public long eO() {
        return this.tX;
    }

    private long eP() {
        long l2 = 0L;
        for (c c2 : this.tV.values()) {
            this.c(c2);
            l2 += c2.ui;
        }
        return l2;
    }

    private static boolean m(List<com.oracle.svm.enterprise.profiling.metadata.codepositions.d> list) {
        for (com.oracle.svm.enterprise.profiling.metadata.codepositions.d d2 : list) {
            for (String string : tZ) {
                if (!d2.fa().format("%H.%n").equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private void c(c c2) {
        c2.ui += c2.uh;
        for (List<c> list : c2.ud.values()) {
            for (c c3 : list) {
                this.c(c3);
                c2.ui += c3.ui;
            }
        }
    }

    public Collection<AnalysisMethod> eQ() {
        return this.tV.keySet();
    }

    public Collection<c> eR() {
        return this.tV.values();
    }

    public c u(HostedMethod hostedMethod) {
        return this.tV.get(hostedMethod.getWrapped());
    }

    public void b(Consumer<List<Pair<c, Integer>>> consumer) {
        for (c c2 : this.tV.values()) {
            c2.a(consumer, new ArrayList<Pair<c, Integer>>(), 0);
        }
    }

    public boolean v(HostedMethod hostedMethod) {
        for (c c2 : this.tV.values()) {
            if (!c2.b(hostedMethod.wrapped)) continue;
            return true;
        }
        return false;
    }

    private static final class a {
        private final List<com.oracle.svm.enterprise.profiling.metadata.codepositions.d> ua;

        private a(List<com.oracle.svm.enterprise.profiling.metadata.codepositions.d> list) {
            this.ua = list;
        }

        public static a n(List<com.oracle.svm.enterprise.profiling.metadata.codepositions.d> list) {
            ArrayList<com.oracle.svm.enterprise.profiling.metadata.codepositions.d> arrayList = new ArrayList<com.oracle.svm.enterprise.profiling.metadata.codepositions.d>(list);
            Collections.reverse(arrayList);
            return new a(arrayList);
        }

        public com.oracle.svm.enterprise.profiling.metadata.codepositions.d eS() {
            return this.ua.get(0);
        }

        public int eT() {
            return this.ua.size();
        }

        public com.oracle.svm.enterprise.profiling.metadata.codepositions.d u(int n2) {
            return this.ua.get(n2);
        }
    }

    public class c
    implements b {
        private final c ub;
        private final AnalysisMethod uc;
        private final Map<Integer, List<c>> ud = new HashMap<Integer, List<c>>();
        private final boolean ue;
        private final D uf;
        private final int ug;
        private long uh;
        private long ui;

        public c(AnalysisMethod analysisMethod) {
            this.uf = d.this.tW.get();
            this.uh = 0L;
            this.ui = 0L;
            this.uc = analysisMethod;
            this.ue = false;
            this.ub = null;
            this.ug = -1;
        }

        public c(AnalysisMethod analysisMethod, boolean bl2, c c2, int n2) {
            this.uf = d.this.tW.get();
            this.uh = 0L;
            this.ui = 0L;
            this.uc = analysisMethod;
            this.ue = bl2;
            this.ub = c2;
            this.ug = n2;
        }

        boolean b(AnalysisMethod analysisMethod) {
            if (this.uc.equals((Object)analysisMethod)) {
                return true;
            }
            for (List<c> list : this.ud.values()) {
                for (c c2 : list) {
                    if (!c2.b(analysisMethod)) continue;
                    return true;
                }
            }
            return false;
        }

        public D eX() {
            return this.uf;
        }

        public long eY() {
            return this.uh;
        }

        public List<c> v(int n2) {
            return this.ud.get(n2);
        }

        public Map<Integer, List<c>> eZ() {
            return this.ud;
        }

        public List<c> a(BytecodePosition bytecodePosition) {
            if (bytecodePosition == null) {
                return null;
            }
            if (bytecodePosition.getCaller() == null) {
                return this.v(bytecodePosition.getBCI());
            }
            List<c> list = this.a(bytecodePosition.getCaller());
            if (list == null) {
                return null;
            }
            c c2 = this.a(list, bytecodePosition.getMethod());
            if (c2 == null) {
                return null;
            }
            return c2.v(bytecodePosition.getBCI());
        }

        private c a(List<c> list, ResolvedJavaMethod resolvedJavaMethod) {
            AnalysisMethod analysisMethod = resolvedJavaMethod instanceof HostedMethod ? ((HostedMethod)resolvedJavaMethod).wrapped : (AnalysisMethod)resolvedJavaMethod;
            for (c c2 : list) {
                if (!c2.uc.equals((Object)analysisMethod)) continue;
                return c2;
            }
            return null;
        }

        public AnalysisMethod fa() {
            return this.uc;
        }

        public void a(a a2, long[] lArray) {
            c c2 = this;
            HashSet<AnalysisMethod> hashSet = new HashSet<AnalysisMethod>();
            for (int i2 = 0; i2 < a2.eT() - 1; ++i2) {
                hashSet.add(c2.uc);
                com.oracle.svm.enterprise.profiling.metadata.codepositions.d d2 = a2.u(i2);
                int n3 = d2.hh();
                AnalysisMethod analysisMethod = a2.u(i2 + 1).fa();
                List list = c2.ud.computeIfAbsent(n3, n2 -> new ArrayList());
                c2 = this.a(list, analysisMethod, hashSet, c2, n3);
            }
            assert (lArray.length == 1);
            c2.uh += lArray[0];
        }

        private c a(List<c> list, AnalysisMethod analysisMethod, Set<AnalysisMethod> set, c c2, int n2) {
            for (c c3 : list) {
                if (!c3.fa().equals((Object)analysisMethod)) continue;
                return c3;
            }
            c c4 = new c(analysisMethod, set.contains(analysisMethod), c2, n2);
            list.add(c4);
            return c4;
        }

        @Override
        public JavaMethodProfile a(HostedUniverse hostedUniverse, BytecodePosition bytecodePosition) {
            List<c> list = this.a(bytecodePosition);
            if (list == null || list.isEmpty()) {
                return null;
            }
            HashMap<HostedMethod, Long> hashMap = new HashMap<HostedMethod, Long>();
            for (c c2 : list) {
                hashMap.put(hostedUniverse.lookup((JavaMethod)c2.fa()), c2.ui);
            }
            return com.oracle.svm.enterprise.hosted.pgo.c.d(hashMap);
        }

        public c b(BytecodePosition bytecodePosition, ResolvedJavaMethod resolvedJavaMethod) {
            List<c> list = this.a(bytecodePosition);
            if (list == null) {
                return null;
            }
            return this.a(list, resolvedJavaMethod);
        }

        @Override
        public b eU() {
            return this.ub;
        }

        @Override
        public boolean eV() {
            return this.fc() >= d.this.tY;
        }

        public boolean fb() {
            return this.ue;
        }

        private double fc() {
            return (double)this.ui / (double)d.this.tX;
        }

        @Override
        public double a(NodeSourcePosition nodeSourcePosition, ResolvedJavaMethod resolvedJavaMethod) {
            c c2 = this.b((BytecodePosition)nodeSourcePosition, resolvedJavaMethod);
            if (c2 == null) {
                return 0.0;
            }
            return (double)c2.ui / (double)this.ui;
        }

        @Override
        public boolean eW() {
            if (!this.fb()) {
                return false;
            }
            ArrayList<AnalysisMethod> arrayList = new ArrayList<AnalysisMethod>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            c c2 = this;
            while (!Objects.equals(c2.ub.uc, this.uc)) {
                arrayList.add(c2.ub.uc);
                arrayList2.add(c2.ub.ug);
                c2 = c2.ub;
            }
            Collections.reverse(arrayList);
            Collections.reverse(arrayList2);
            c2 = this;
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                int n2;
                AnalysisMethod analysisMethod = (AnalysisMethod)arrayList.get(i2);
                if ((c2 = this.a(c2, analysisMethod, n2 = ((Integer)arrayList2.get(i2)).intValue())) != null) continue;
                return false;
            }
            return true;
        }

        private c a(c c2, AnalysisMethod analysisMethod, int n2) {
            List<c> list = c2.ud.get(n2);
            if (list == null) {
                return null;
            }
            for (c c3 : list) {
                if (!c3.uc.equals((Object)analysisMethod)) continue;
                return c3;
            }
            return null;
        }

        private void a(Consumer<List<Pair<c, Integer>>> consumer, List<Pair<c, Integer>> list, int n3) {
            Pair pair = Pair.create((Object)this, (Object)n3);
            list.add((Pair<c, Integer>)pair);
            consumer.accept(list);
            this.ud.forEach((n2, list2) -> {
                for (c c2 : list2) {
                    c2.a(consumer, list, (int)n2);
                }
            });
            list.remove(pair);
        }

        public long fd() {
            return this.ui;
        }

        @Override
        public /* synthetic */ b a(BytecodePosition bytecodePosition, ResolvedJavaMethod resolvedJavaMethod) {
            return this.b(bytecodePosition, resolvedJavaMethod);
        }
    }

    public static interface b {
        public JavaMethodProfile a(HostedUniverse var1, BytecodePosition var2);

        public b a(BytecodePosition var1, ResolvedJavaMethod var2);

        public b eU();

        public boolean eV();

        public double a(NodeSourcePosition var1, ResolvedJavaMethod var2);

        public boolean eW();
    }
}

