/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.net.URI;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

final class ResourceMetadataParser
extends ResourceConfigurationParser {
    ResourceMetadataParser(ConfigurationConditionResolver conditionResolver, ResourcesRegistry registry, boolean strictConfiguration) {
        super(conditionResolver, registry, strictConfiguration);
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        Object bundlesJson;
        Object resourcesJson = this.getFromGlobalFile(json, "resources");
        if (resourcesJson != null) {
            this.parseGlobsObject(resourcesJson);
        }
        if ((bundlesJson = this.getFromGlobalFile(json, "bundles")) != null) {
            this.parseBundlesObject(bundlesJson);
        }
    }

    @Override
    protected ConfigurationCondition parseCondition(EconomicMap<String, Object> data) {
        return this.parseCondition(data, true);
    }
}

