/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.SerialAndEpsilonGCOptions;
import com.oracle.svm.core.genscavenge.UseSerialOrEpsilonGC;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.util.PointerUtils;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class AlignedHeapChunk {
    private AlignedHeapChunk() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initialize(AlignedHeader chunk, UnsignedWord chunkSize) {
        HeapChunk.initialize(chunk, AlignedHeapChunk.getObjectsStart(chunk), chunkSize);
    }

    public static void reset(AlignedHeader chunk) {
        long alignedChunkSize = SerialAndEpsilonGCOptions.AlignedHeapChunkSize.getValue();
        assert (HeapChunk.getEndOffset(chunk).rawValue() == alignedChunkSize);
        AlignedHeapChunk.initialize(chunk, WordFactory.unsigned((long)alignedChunkSize));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getObjectsStart(AlignedHeader that) {
        return HeapChunk.asPointer(that).add(AlignedHeapChunk.getObjectsStartOffset());
    }

    public static Pointer getObjectsEnd(AlignedHeader that) {
        return HeapChunk.getEndPointer(that);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static Pointer allocateMemory(AlignedHeader that, UnsignedWord size) {
        Pointer result = (Pointer)WordFactory.nullPointer();
        UnsignedWord available = HeapChunk.availableObjectMemory(that);
        if (size.belowOrEqual(available)) {
            result = HeapChunk.getTopPointer(that);
            Pointer newTop = result.add(size);
            HeapChunk.setTopPointerCarefully(that, newTop);
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static UnsignedWord getCommittedObjectMemory(AlignedHeader that) {
        return HeapChunk.getEndOffset(that).subtract(AlignedHeapChunk.getObjectsStartOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static AlignedHeader getEnclosingChunk(Object obj) {
        Word ptr = Word.objectToUntrackedPointer((Object)obj);
        return AlignedHeapChunk.getEnclosingChunkFromObjectPointer((Pointer)ptr);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static AlignedHeader getEnclosingChunkFromObjectPointer(Pointer ptr) {
        return (AlignedHeader)PointerUtils.roundDown((PointerBase)ptr, HeapParameters.getAlignedHeapChunkAlignment());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getObjectOffset(AlignedHeader that, Pointer objectPointer) {
        Pointer objectsStart = AlignedHeapChunk.getObjectsStart(that);
        return objectPointer.subtract((UnsignedWord)objectsStart);
    }

    static boolean walkObjects(AlignedHeader that, ObjectVisitor visitor) {
        return HeapChunk.walkObjectsFrom(that, AlignedHeapChunk.getObjectsStart(that), visitor);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static boolean walkObjectsInline(AlignedHeader that, ObjectVisitor visitor) {
        return HeapChunk.walkObjectsFromInline(that, AlignedHeapChunk.getObjectsStart(that), visitor);
    }

    @Fold
    public static UnsignedWord getObjectsStartOffset() {
        return RememberedSet.get().getHeaderSizeOfAlignedChunk();
    }

    @Fold
    static MemoryWalker.HeapChunkAccess<AlignedHeader> getMemoryWalkerAccess() {
        return (MemoryWalker.HeapChunkAccess)ImageSingletons.lookup(MemoryWalkerAccessImpl.class);
    }

    @RawStructure
    public static interface AlignedHeader
    extends HeapChunk.Header<AlignedHeader> {
    }

    @AutomaticallyRegisteredImageSingleton(onlyWith={UseSerialOrEpsilonGC.class})
    static final class MemoryWalkerAccessImpl
    extends HeapChunk.MemoryWalkerAccessImpl<AlignedHeader> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        MemoryWalkerAccessImpl() {
        }

        @Override
        public boolean isAligned(AlignedHeader heapChunk) {
            return true;
        }

        @Override
        public UnsignedWord getAllocationStart(AlignedHeader heapChunk) {
            return AlignedHeapChunk.getObjectsStart(heapChunk);
        }
    }
}

