/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jdk.internal.module.ServicesCatalog;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredImageSingleton
@Platforms(value={Platform.HOSTED_ONLY.class})
public class ServiceCatalogSupport {
    final ConcurrentHashMap<String, Set<String>> omittedServiceProviders = new ConcurrentHashMap();
    boolean sealed;

    public static ServiceCatalogSupport singleton() {
        return (ServiceCatalogSupport)ImageSingletons.lookup(ServiceCatalogSupport.class);
    }

    public void seal() {
        this.sealed = true;
    }

    public void removeServicesFromServicesCatalog(String serviceProvider, Set<String> services) {
        VMError.guarantee(!this.sealed, "Removing services from a catalog is allowed only before analysis. ServiceCatalogSupport.removeServicesFromServicesCatalog called during or after analysis. ");
        this.omittedServiceProviders.put(serviceProvider, services);
    }

    public void enableServiceCatalogMapTransformer(Feature.BeforeAnalysisAccess access) {
        access.registerFieldValueTransformer(ReflectionUtil.lookupField(ServicesCatalog.class, (String)"map"), (receiver, original) -> {
            VMError.guarantee(this.sealed);
            ConcurrentHashMap map = (ConcurrentHashMap)original;
            ConcurrentHashMap res = new ConcurrentHashMap();
            map.forEach((key, value) -> {
                if (this.omittedServiceProviders.containsKey(key)) {
                    Set<String> omittedServices = this.omittedServiceProviders.get(key);
                    List filtered = value.stream().filter(v -> !omittedServices.contains(v.providerName())).collect(Collectors.toList());
                    res.put(key, filtered);
                } else {
                    res.put(key, value);
                }
            });
            return res;
        });
    }
}

