/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.fieldvaluetransformer.FieldValueTransformerWithAvailability;
import com.oracle.svm.core.jdk.VarHandleFeature;
import java.lang.reflect.Field;
import org.graalvm.nativeimage.ImageSingletons;

class StaticAccessorFieldStaticBaseComputer
implements FieldValueTransformerWithAvailability {
    StaticAccessorFieldStaticBaseComputer() {
    }

    @Override
    public FieldValueTransformerWithAvailability.ValueAvailability valueAvailability() {
        return FieldValueTransformerWithAvailability.ValueAvailability.AfterAnalysis;
    }

    public Object transform(Object receiver, Object originalValue) {
        Field field = ((VarHandleFeature)ImageSingletons.lookup(VarHandleFeature.class)).findVarHandleField(receiver);
        if (field.getType().isPrimitive()) {
            return StaticFieldsSupport.getStaticPrimitiveFields();
        }
        return StaticFieldsSupport.getStaticObjectFields();
    }
}

