/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrMetadataTypeLibrary;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.thread.JavaThreads;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JfrEvent {
    public static final JfrEvent ThreadStart = JfrEvent.create("jdk.ThreadStart", false);
    public static final JfrEvent ThreadEnd = JfrEvent.create("jdk.ThreadEnd", false);
    public static final JfrEvent ThreadCPULoad = JfrEvent.create("jdk.ThreadCPULoad", false);
    public static final JfrEvent DataLoss = JfrEvent.create("jdk.DataLoss", false);
    public static final JfrEvent ClassLoadingStatistics = JfrEvent.create("jdk.ClassLoadingStatistics", false);
    public static final JfrEvent InitialEnvironmentVariable = JfrEvent.create("jdk.InitialEnvironmentVariable", false);
    public static final JfrEvent InitialSystemProperty = JfrEvent.create("jdk.InitialSystemProperty", false);
    public static final JfrEvent JavaThreadStatistics = JfrEvent.create("jdk.JavaThreadStatistics", false);
    public static final JfrEvent JVMInformation = JfrEvent.create("jdk.JVMInformation", false);
    public static final JfrEvent OSInformation = JfrEvent.create("jdk.OSInformation", false);
    public static final JfrEvent PhysicalMemory = JfrEvent.create("jdk.PhysicalMemory", false);
    public static final JfrEvent ExecutionSample = JfrEvent.create("jdk.ExecutionSample", false);
    public static final JfrEvent NativeMethodSample = JfrEvent.create("jdk.NativeMethodSample", false);
    public static final JfrEvent GarbageCollection = JfrEvent.create("jdk.GarbageCollection", true);
    public static final JfrEvent GCPhasePause = JfrEvent.create("jdk.GCPhasePause", true);
    public static final JfrEvent GCPhasePauseLevel1 = JfrEvent.create("jdk.GCPhasePauseLevel1", true);
    public static final JfrEvent GCPhasePauseLevel2 = JfrEvent.create("jdk.GCPhasePauseLevel2", true);
    public static final JfrEvent GCPhasePauseLevel3 = JfrEvent.create("jdk.GCPhasePauseLevel3", true);
    public static final JfrEvent GCPhasePauseLevel4 = JfrEvent.create("jdk.GCPhasePauseLevel4", true);
    public static final JfrEvent SafepointBegin = JfrEvent.create("jdk.SafepointBegin", true);
    public static final JfrEvent SafepointEnd = JfrEvent.create("jdk.SafepointEnd", true);
    public static final JfrEvent ExecuteVMOperation = JfrEvent.create("jdk.ExecuteVMOperation", true);
    public static final JfrEvent JavaMonitorEnter = JfrEvent.create("jdk.JavaMonitorEnter", true);
    public static final JfrEvent ThreadPark = JfrEvent.create("jdk.ThreadPark", true);
    public static final JfrEvent JavaMonitorWait = JfrEvent.create("jdk.JavaMonitorWait", true);
    public static final JfrEvent JavaMonitorInflate = JfrEvent.create("jdk.JavaMonitorInflate", true);
    public static final JfrEvent ObjectAllocationInNewTLAB = JfrEvent.create("jdk.ObjectAllocationInNewTLAB", false);
    public static final JfrEvent GCHeapSummary = JfrEvent.create("jdk.GCHeapSummary", false);
    private final long id;
    private final String name;
    private final boolean hasDuration;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static JfrEvent create(String name, boolean hasDuration) {
        return new JfrEvent(name, hasDuration);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JfrEvent(String name, boolean hasDuration) {
        this.id = JfrMetadataTypeLibrary.lookupPlatformEvent(name);
        this.name = name;
        this.hasDuration = hasDuration;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getId() {
        return this.id;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public String getName() {
        return this.name;
    }

    @Uninterruptible(reason="Prevent races with VM operations that start/stop recording.", callerMustBe=true)
    public boolean shouldEmit() {
        assert (!this.hasDuration);
        return this.shouldEmit0() && !JfrThreadLocal.isThreadExcluded(JavaThreads.getCurrentThreadOrNull());
    }

    @Uninterruptible(reason="Prevent races with VM operations that start/stop recording.", callerMustBe=true)
    public boolean shouldEmit(Thread thread) {
        assert (!this.hasDuration);
        return this.shouldEmit0() && !JfrThreadLocal.isThreadExcluded(thread);
    }

    @Uninterruptible(reason="Prevent races with VM operations that start/stop recording.", callerMustBe=true)
    public boolean shouldEmit(long durationTicks) {
        assert (this.hasDuration);
        return this.shouldEmit0() && durationTicks >= SubstrateJVM.get().getThresholdTicks(this) && !JfrThreadLocal.isThreadExcluded(JavaThreads.getCurrentThreadOrNull());
    }

    @Uninterruptible(reason="Prevent races with VM operations that start/stop recording.", callerMustBe=true)
    private boolean shouldEmit0() {
        return SubstrateJVM.get().isRecording() && SubstrateJVM.get().isEnabled(this);
    }
}

