/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.jfr.JfrGCName;
import java.util.Arrays;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrGCNames {
    private JfrGCName[] names = new JfrGCName[0];

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrGCNames() {
    }

    @Fold
    public static JfrGCNames singleton() {
        return (JfrGCNames)ImageSingletons.lookup(JfrGCNames.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public synchronized JfrGCName addGCName(String name) {
        int id = this.names.length;
        JfrGCName result = new JfrGCName(id, name);
        JfrGCName[] newArr = Arrays.copyOf(this.names, id + 1);
        newArr[id] = result;
        this.names = newArr;
        return result;
    }

    public JfrGCName[] getNames() {
        return this.names;
    }
}

