/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrSerializer;
import com.oracle.svm.core.jfr.JfrType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrVMOperationNameSerializer
implements JfrSerializer {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrVMOperationNameSerializer() {
    }

    @Override
    public void write(JfrChunkWriter writer) {
        String[] vmOperationNames = VMOperationInfos.getNames();
        writer.writeCompressedLong(JfrType.VMOperation.getId());
        writer.writeCompressedLong(vmOperationNames.length);
        for (int id = 0; id < vmOperationNames.length; ++id) {
            writer.writeCompressedLong(id + 1);
            writer.writeString(vmOperationNames[id]);
        }
    }
}

