/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.darwin.DarwinTime;
import jdk.internal.misc.Unsafe;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;

@AutomaticallyRegisteredImageSingleton
final class DarwinTimeUtil {
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long INITIALIZED_OFFSET = U.objectFieldOffset(DarwinTimeUtil.class, "initialized");
    private static final long MAX_ABS_TIME_OFFSET = U.objectFieldOffset(DarwinTimeUtil.class, "maxAbsTime");
    private volatile boolean initialized;
    private volatile long maxAbsTime;
    private int numer;
    private int denom;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    DarwinTimeUtil() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    long nanoTime() {
        long prev;
        long tm2;
        long now;
        if (!U.getBooleanAcquire(this, INITIALIZED_OFFSET)) {
            DarwinTime.MachTimebaseInfo timeBaseInfo = (DarwinTime.MachTimebaseInfo)StackValue.get(DarwinTime.MachTimebaseInfo.class);
            int status = DarwinTime.NoTransitions.mach_timebase_info(timeBaseInfo);
            PosixUtils.checkStatusIs0(status, "mach_timebase_info() failed.");
            this.numer = timeBaseInfo.getnumer();
            this.denom = timeBaseInfo.getdenom();
            U.putBooleanRelease(this, INITIALIZED_OFFSET, true);
        }
        if ((now = (tm2 = DarwinTime.NoTransitions.mach_absolute_time()) * (long)this.numer / (long)this.denom) <= (prev = U.getLongOpaque(this, MAX_ABS_TIME_OFFSET))) {
            return prev;
        }
        long obsv = U.compareAndExchangeLong(this, MAX_ABS_TIME_OFFSET, prev, now);
        assert (obsv >= prev) : "invariant to ensure monotonicity";
        return prev == obsv ? now : obsv;
    }
}

