/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.SubstrateField;
import com.oracle.svm.graal.meta.SubstrateMetaAccess;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordBase;

public class SubstrateType
implements SharedType {
    private final JavaKind kind;
    private final DynamicHub hub;
    @UnknownObjectField(canBeNull=true)
    SubstrateField[] rawAllInstanceFields;
    @UnknownObjectField
    protected DynamicHub uniqueConcreteImplementation;

    public SubstrateType(JavaKind kind, DynamicHub hub) {
        this.kind = kind;
        this.hub = hub;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setRawAllInstanceFields(SubstrateField[] allInstanceFields) {
        this.rawAllInstanceFields = allInstanceFields.length == 0 ? SubstrateField.EMPTY_ARRAY : allInstanceFields;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateField[] getRawAllInstanceFields() {
        return this.rawAllInstanceFields;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void setTypeCheckData(DynamicHub uniqueConcreteImplementation) {
        this.uniqueConcreteImplementation = uniqueConcreteImplementation;
    }

    @Override
    public final JavaKind getStorageKind() {
        if (WordBase.class.isAssignableFrom(DynamicHub.toClass(this.hub))) {
            return FrameAccess.getWordKind();
        }
        return this.getJavaKind();
    }

    @Override
    public DynamicHub getHub() {
        return this.hub;
    }

    public String getName() {
        return MetaUtil.toInternalName((String)this.hub.getName());
    }

    public JavaKind getJavaKind() {
        return this.kind;
    }

    public ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        return this;
    }

    public boolean hasFinalizer() {
        return false;
    }

    public Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        return new Assumptions.AssumptionResult((Object)false);
    }

    public boolean isInterface() {
        return this.hub.isInterface();
    }

    public boolean isInstanceClass() {
        return this.hub.isInstanceClass();
    }

    public boolean isArray() {
        return DynamicHub.toClass(this.hub).isArray();
    }

    public boolean isPrimitive() {
        return this.hub.isPrimitive();
    }

    public boolean isEnum() {
        throw VMError.unimplemented("Enum support not implemented");
    }

    public int getModifiers() {
        return this.hub.getModifiers();
    }

    public boolean isInitialized() {
        return this.hub.isInitialized();
    }

    public void initialize() {
        this.hub.ensureInitialized();
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        return DynamicHub.toClass(this.hub).isAssignableFrom(DynamicHub.toClass(((SubstrateType)other).hub));
    }

    public boolean isInstance(JavaConstant obj) {
        if (obj.getJavaKind() == JavaKind.Object && !obj.isNull()) {
            DynamicHub objHub = KnownIntrinsics.readHub(SubstrateObjectConstant.asObject((Constant)obj));
            return DynamicHub.toClass(this.hub).isAssignableFrom(DynamicHub.toClass(objHub));
        }
        return false;
    }

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        ResolvedJavaType result = this.getSingleImplementor();
        if (result == null) {
            return null;
        }
        return new Assumptions.AssumptionResult((Object)result);
    }

    public ResolvedJavaType getSingleImplementor() {
        if (this.uniqueConcreteImplementation == null) {
            return null;
        }
        return SubstrateMetaAccess.singleton().lookupJavaType((Class)DynamicHub.toClass(this.uniqueConcreteImplementation));
    }

    public SubstrateType getSuperclass() {
        DynamicHub superHub = this.hub.getSuperHub();
        if (superHub == null) {
            return null;
        }
        return SubstrateMetaAccess.singleton().lookupJavaTypeFromHub(superHub);
    }

    public ResolvedJavaType[] getInterfaces() {
        DynamicHub[] hubs = this.hub.getInterfaces();
        ResolvedJavaType[] result = new SubstrateType[hubs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SubstrateMetaAccess.singleton().lookupJavaTypeFromHub(hubs[i]);
        }
        return result;
    }

    private SubstrateType getSuperType() {
        if (this.isArray() || this.isInterface()) {
            return SubstrateMetaAccess.singleton().lookupJavaType((Class)Object.class);
        }
        return this.getSuperclass();
    }

    public ResolvedJavaType findLeastCommonAncestor(ResolvedJavaType otherType) {
        if (this.isPrimitive() || otherType.isPrimitive()) {
            return null;
        }
        SubstrateType t1 = this;
        SubstrateType t2 = (SubstrateType)otherType;
        while (!t1.isAssignableFrom(t2)) {
            if (t2.isAssignableFrom(t1)) {
                return t2;
            }
            t1 = t1.getSuperType();
            t2 = t2.getSuperType();
        }
        return t1;
    }

    public boolean isJavaLangObject() {
        return DynamicHub.toClass(this.hub) == Object.class;
    }

    public ResolvedJavaType getComponentType() {
        if (this.hub.getComponentHub() == null) {
            return null;
        }
        return SubstrateMetaAccess.singleton().lookupJavaTypeFromHub(this.hub.getComponentHub());
    }

    public ResolvedJavaType getArrayClass() {
        if (this.hub.getArrayHub() == null) {
            return null;
        }
        return SubstrateMetaAccess.singleton().lookupJavaTypeFromHub(this.hub.getArrayHub());
    }

    public SubstrateField[] getInstanceFields(boolean includeSuperclasses) {
        if (this.rawAllInstanceFields == null) {
            throw VMError.shouldNotReachHere("No instance fields for " + this.hub.getName() + " available");
        }
        SubstrateType superclass = this.getSuperclass();
        if (includeSuperclasses || superclass == null) {
            return this.rawAllInstanceFields;
        }
        int totalCount = this.getInstanceFieldCount();
        int superCount = superclass.getInstanceFieldCount();
        assert (totalCount >= superCount);
        if (totalCount == superCount) {
            return SubstrateField.EMPTY_ARRAY;
        }
        if (superCount == 0) {
            return this.rawAllInstanceFields;
        }
        assert (Arrays.equals(superclass.getInstanceFields(true), Arrays.copyOf(this.rawAllInstanceFields, superCount))) : "Superclass fields must be the first elements of the fields defined in this class";
        return Arrays.copyOfRange(this.rawAllInstanceFields, superCount, totalCount);
    }

    public int getInstanceFieldCount() {
        return this.rawAllInstanceFields.length;
    }

    public ResolvedJavaField[] getStaticFields() {
        throw VMError.intentionallyUnimplemented();
    }

    public Annotation[] getAnnotations() {
        return DynamicHub.toClass(this.getHub()).getAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return DynamicHub.toClass(this.getHub()).getDeclaredAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return DynamicHub.toClass(this.getHub()).getAnnotation(annotationClass);
    }

    public SubstrateField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        assert (offset >= 0L);
        if (this.rawAllInstanceFields == null) {
            if (this.getSuperclass() != null) {
                return this.getSuperclass().findInstanceFieldWithOffset(offset, expectedKind);
            }
        } else {
            for (SubstrateField field : this.rawAllInstanceFields) {
                if (!SubstrateType.fieldMatches(field, offset)) continue;
                return field;
            }
        }
        return null;
    }

    private static boolean fieldMatches(SubstrateField field, long offset) {
        return (long)field.getLocation() == offset;
    }

    public String getSourceFileName() {
        return this.hub.getSourceFileName();
    }

    public boolean isLocal() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isMember() {
        throw VMError.intentionallyUnimplemented();
    }

    public ResolvedJavaType getEnclosingType() {
        Class<?> enclosingClass = DynamicHub.toClass(this.hub).getEnclosingClass();
        if (enclosingClass == null) {
            return null;
        }
        return SubstrateMetaAccess.singleton().lookupJavaType((Class)enclosingClass);
    }

    public ResolvedJavaMethod[] getDeclaredConstructors() {
        return this.getDeclaredConstructors(true);
    }

    public ResolvedJavaMethod[] getDeclaredConstructors(boolean forceLink) {
        throw VMError.intentionallyUnimplemented();
    }

    public ResolvedJavaMethod[] getDeclaredMethods() {
        return this.getDeclaredMethods(true);
    }

    public ResolvedJavaMethod[] getDeclaredMethods(boolean forceLink) {
        throw VMError.intentionallyUnimplemented();
    }

    public ResolvedJavaMethod getClassInitializer() {
        throw VMError.intentionallyUnimplemented();
    }

    public boolean isLinked() {
        return this.hub.isLinked();
    }

    public void link() {
        if (!this.isLinked()) {
            throw new LinkageError(String.format("Cannot link new type at run time: %s", this));
        }
    }

    public boolean hasDefaultMethods() {
        return this.hub.hasDefaultMethods();
    }

    public boolean declaresDefaultMethods() {
        return this.hub.declaresDefaultMethods();
    }

    public boolean isCloneableWithAllocation() {
        return SubstrateMetaAccess.singleton().lookupJavaType((Class)Cloneable.class).isAssignableFrom(this);
    }

    public ResolvedJavaType getHostClass() {
        throw VMError.intentionallyUnimplemented();
    }

    public int hashCode() {
        return this.hub.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SubstrateType && ((SubstrateType)obj).hub == this.hub;
    }

    public String toString() {
        return "SubstrateType<" + this.toJavaName(true) + ">";
    }
}

