/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.GraalAccess;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
final class AnalysisMethodHandleAccessProvider
implements MethodHandleAccessProvider {
    private final AnalysisUniverse analysisUniverse;
    private final MethodHandleAccessProvider originalMethodHandleAccess;
    private final SnippetReflectionProvider originalSnippetReflection;

    AnalysisMethodHandleAccessProvider(AnalysisUniverse analysisUniverse) {
        assert (analysisUniverse != null);
        this.analysisUniverse = analysisUniverse;
        this.originalMethodHandleAccess = GraalAccess.getOriginalProviders().getConstantReflection().getMethodHandleAccess();
        this.originalSnippetReflection = GraalAccess.getOriginalSnippetReflection();
    }

    public MethodHandleAccessProvider.IntrinsicMethod lookupMethodHandleIntrinsic(ResolvedJavaMethod method) {
        ResolvedJavaMethod unwrapped = ((AnalysisMethod)method).getWrapped();
        unwrapped = this.analysisUniverse.resolveSubstitution(unwrapped);
        assert (!(unwrapped instanceof WrappedJavaMethod) && !(unwrapped instanceof OriginalMethodProvider));
        if (unwrapped instanceof GraphProvider) {
            return null;
        }
        return this.originalMethodHandleAccess.lookupMethodHandleIntrinsic(unwrapped);
    }

    public ResolvedJavaMethod resolveInvokeBasicTarget(JavaConstant methodHandle, boolean forceBytecodeGeneration) {
        JavaConstant originalMethodHandle = this.toOriginalConstant(methodHandle);
        if (originalMethodHandle == null) {
            return null;
        }
        ResolvedJavaMethod originalTarget = this.originalMethodHandleAccess.resolveInvokeBasicTarget(originalMethodHandle, forceBytecodeGeneration);
        return this.analysisUniverse.lookup((JavaMethod)originalTarget);
    }

    public ResolvedJavaMethod resolveLinkToTarget(JavaConstant memberName) {
        JavaConstant originalMemberName = this.toOriginalConstant(memberName);
        if (originalMemberName == null) {
            return null;
        }
        ResolvedJavaMethod method = this.originalMethodHandleAccess.resolveLinkToTarget(originalMemberName);
        return this.analysisUniverse.lookup((JavaMethod)method);
    }

    private JavaConstant toOriginalConstant(JavaConstant c) {
        JavaConstant constant = c;
        if (constant instanceof ImageHeapConstant) {
            ImageHeapConstant imageHeapConstant = (ImageHeapConstant)constant;
            constant = imageHeapConstant.getHostedObject();
        }
        if (constant == null) {
            return null;
        }
        Object obj = this.analysisUniverse.getSnippetReflection().asObject(Object.class, constant);
        return this.originalSnippetReflection.forObject(obj);
    }
}

