/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.hosted.HostedConfiguration;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.analysis.CallChecker;
import com.oracle.svm.hosted.analysis.CustomTypeFieldHandler;
import com.oracle.svm.hosted.analysis.DynamicHubInitializer;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.analysis.PointsToCustomTypeFieldHandler;
import com.oracle.svm.hosted.analysis.UserLimitationsChecker;
import com.oracle.svm.hosted.code.IncompatibleClassChangeFallbackMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ForkJoinPool;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.word.WordTypes;

public class NativeImagePointsToAnalysis
extends PointsToAnalysis
implements Inflation {
    private final AnnotationSubstitutionProcessor annotationSubstitutionProcessor;
    private final DynamicHubInitializer dynamicHubInitializer;
    private final CustomTypeFieldHandler customTypeFieldHandler;
    private final CallChecker callChecker;

    public NativeImagePointsToAnalysis(OptionValues options, AnalysisUniverse universe, AnalysisMetaAccess metaAccess, SnippetReflectionProvider snippetReflectionProvider, ConstantReflectionProvider constantReflectionProvider, WordTypes wordTypes, AnnotationSubstitutionProcessor annotationSubstitutionProcessor, ForkJoinPool executor, Runnable heartbeatCallback, UnsupportedFeatures unsupportedFeatures, TimerCollection timerCollection) {
        super(options, universe, universe.hostVM(), metaAccess, snippetReflectionProvider, constantReflectionProvider, wordTypes, executor, heartbeatCallback, unsupportedFeatures, timerCollection, SubstrateOptions.parseOnce());
        this.annotationSubstitutionProcessor = annotationSubstitutionProcessor;
        this.dynamicHubInitializer = new DynamicHubInitializer(this);
        this.customTypeFieldHandler = new PointsToCustomTypeFieldHandler(this, metaAccess);
        this.callChecker = new CallChecker();
    }

    public boolean isCallAllowed(PointsToAnalysis bb, AnalysisMethod caller, AnalysisMethod target, BytecodePosition srcPosition) {
        return this.callChecker.isCallAllowed((BigBang)bb, caller, target, srcPosition);
    }

    public MethodTypeFlowBuilder createMethodTypeFlowBuilder(PointsToAnalysis bb, PointsToAnalysisMethod methodFlow, MethodFlowsGraph flowsGraph, MethodFlowsGraph.GraphKind graphKind) {
        return HostedConfiguration.instance().createMethodTypeFlowBuilder(bb, methodFlow, flowsGraph, graphKind);
    }

    @Override
    public SVMHost getHostVM() {
        return (SVMHost)this.hostVM;
    }

    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.customTypeFieldHandler.cleanupAfterAnalysis();
    }

    public void checkUserLimitations() {
        super.checkUserLimitations();
        UserLimitationsChecker.check(this);
    }

    @Override
    public AnnotationSubstitutionProcessor getAnnotationSubstitutionProcessor() {
        return this.annotationSubstitutionProcessor;
    }

    public void onFieldAccessed(AnalysisField field) {
        this.customTypeFieldHandler.handleField(field);
    }

    public void onTypeReachable(AnalysisType type) {
        this.postTask(d -> type.getInitializeMetaDataTask().ensureDone());
    }

    public void initializeMetaData(AnalysisType type) {
        this.dynamicHubInitializer.initializeMetaData(this.universe.getHeapScanner(), type);
    }

    public static ResolvedJavaType toWrappedType(ResolvedJavaType type) {
        if (type instanceof AnalysisType) {
            return ((AnalysisType)type).getWrapped();
        }
        if (type instanceof HostedType) {
            return ((HostedType)type).getWrapped().getWrapped();
        }
        return type;
    }

    public boolean trackConcreteAnalysisObjects(AnalysisType type) {
        return !SVMHost.isUnknownClass((ResolvedJavaType)type);
    }

    public AnalysisMethod fallbackResolveConcreteMethod(AnalysisType resolvingType, AnalysisMethod method) {
        if (!resolvingType.isAbstract() && !resolvingType.isInterface() && !method.isStatic() && method.getDeclaringClass().isAssignableFrom((ResolvedJavaType)resolvingType)) {
            if (method.getWrapped() instanceof IncompatibleClassChangeFallbackMethod) {
                return method;
            }
            return this.getUniverse().lookup((JavaMethod)new IncompatibleClassChangeFallbackMethod(resolvingType.getWrapped(), method.getWrapped(), NativeImagePointsToAnalysis.findResolutionError(resolvingType, method.getJavaMethod())));
        }
        return super.fallbackResolveConcreteMethod(resolvingType, method);
    }

    private static Class<? extends IncompatibleClassChangeError> findResolutionError(AnalysisType resolvingType, Executable searchMethod) {
        if (searchMethod != null) {
            Class<?>[] searchSignature = searchMethod.getParameterTypes();
            for (Class cur = resolvingType.getJavaClass(); cur != null; cur = cur.getSuperclass()) {
                Method found;
                try {
                    found = cur.getDeclaredMethod(searchMethod.getName(), searchSignature);
                }
                catch (Throwable ex) {
                    continue;
                }
                if (Modifier.isAbstract(found.getModifiers()) || Modifier.isPrivate(found.getModifiers()) || Modifier.isStatic(found.getModifiers())) {
                    return AbstractMethodError.class;
                }
                return IllegalAccessError.class;
            }
        }
        return AbstractMethodError.class;
    }
}

