/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.config.SignatureUtil;
import com.oracle.svm.core.util.json.JsonPrintable;
import com.oracle.svm.core.util.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import jdk.vm.ci.meta.MetaUtil;

public class ConfigurationMethod
implements JsonPrintable {
    public static final String CONSTRUCTOR_NAME = "<init>";
    private final String name;
    private final String internalSignature;
    private final int hash;

    public static boolean isConstructorName(String name) {
        return CONSTRUCTOR_NAME.equals(name);
    }

    public static String toInternalParamsSignature(List<ConfigurationType> types) {
        StringBuilder sb = new StringBuilder("(");
        for (ConfigurationType type : types) {
            sb.append(MetaUtil.toInternalName((String)type.getQualifiedJavaName()));
        }
        sb.append(')');
        return sb.toString();
    }

    public ConfigurationMethod(String name, String internalSignature) {
        this.name = name;
        String paramsOnlySignature = internalSignature;
        if (paramsOnlySignature != null) {
            int paramsEnd = internalSignature.lastIndexOf(41);
            paramsOnlySignature = paramsOnlySignature.substring(0, paramsEnd + 1);
        }
        this.internalSignature = paramsOnlySignature;
        this.hash = name.hashCode() * 31 + (this.internalSignature == null ? 0 : this.internalSignature.hashCode());
    }

    public String getName() {
        return this.name;
    }

    public String getInternalSignature() {
        return this.internalSignature;
    }

    public boolean matches(String methodName, String methodInternalSignature) {
        return this.getName().equals(methodName) && (this.internalSignature == null || methodInternalSignature.startsWith(this.internalSignature));
    }

    public boolean isConstructor() {
        return ConfigurationMethod.isConstructorName(this.name);
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.append('{');
        writer.quote("name").append(':').quote(this.name).append(',');
        writer.quote("parameterTypes").append(":[");
        String prefix = "";
        for (String type : SignatureUtil.toParameterTypes(this.internalSignature)) {
            writer.append(prefix).quote(type);
            prefix = ",";
        }
        writer.append("] }");
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj != this && obj instanceof ConfigurationMethod) {
            ConfigurationMethod other = (ConfigurationMethod)obj;
            return this.name.equals(other.name) && Objects.equals(this.internalSignature, other.internalSignature);
        }
        return obj == this;
    }

    public String toString() {
        return "ConfigurationMethod{name='" + this.name + "', internalSignature='" + this.internalSignature + "', hash=" + this.hash + "}";
    }
}

