/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.config.ConfigurationConditionPrintable;
import com.oracle.svm.core.util.json.JsonPrintable;
import com.oracle.svm.core.util.json.JsonWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class SerializationConfigurationType
implements JsonPrintable,
Comparable<SerializationConfigurationType> {
    private final ConfigurationCondition condition;
    private final String qualifiedJavaName;
    private final String qualifiedCustomTargetConstructorJavaName;

    public SerializationConfigurationType(ConfigurationCondition condition, String qualifiedJavaName, String qualifiedCustomTargetConstructorJavaName) {
        assert (qualifiedJavaName.indexOf(47) == -1) : "Requires qualified Java name, not the internal representation";
        assert (!qualifiedJavaName.startsWith("[")) : "Requires Java source array syntax, for example java.lang.String[]";
        assert (qualifiedCustomTargetConstructorJavaName == null || qualifiedCustomTargetConstructorJavaName.indexOf(47) == -1) : "Requires qualified Java name, not internal representation";
        assert (qualifiedCustomTargetConstructorJavaName == null || !qualifiedCustomTargetConstructorJavaName.startsWith("[")) : "Requires Java source array syntax, for example java.lang.String[]";
        Objects.requireNonNull(condition);
        this.condition = condition;
        Objects.requireNonNull(qualifiedJavaName);
        this.qualifiedJavaName = qualifiedJavaName;
        this.qualifiedCustomTargetConstructorJavaName = qualifiedCustomTargetConstructorJavaName;
    }

    public String getQualifiedJavaName() {
        return this.qualifiedJavaName;
    }

    public String getQualifiedCustomTargetConstructorJavaName() {
        return this.qualifiedCustomTargetConstructorJavaName;
    }

    public ConfigurationCondition getCondition() {
        return this.condition;
    }

    public void printJson(JsonWriter writer) throws IOException {
        writer.append('{').indent().newline();
        ConfigurationConditionPrintable.printConditionAttribute(this.condition, writer);
        writer.quote("name").append(':').quote(this.qualifiedJavaName);
        if (this.qualifiedCustomTargetConstructorJavaName != null) {
            writer.append(',').newline();
            writer.quote("customTargetConstructorClass").append(':').quote(this.qualifiedCustomTargetConstructorJavaName);
        }
        writer.unindent().newline().append('}');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializationConfigurationType that = (SerializationConfigurationType)o;
        return this.condition.equals((Object)that.condition) && this.qualifiedJavaName.equals(that.qualifiedJavaName) && Objects.equals(this.qualifiedCustomTargetConstructorJavaName, that.qualifiedCustomTargetConstructorJavaName);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.qualifiedJavaName, this.qualifiedCustomTargetConstructorJavaName);
    }

    @Override
    public int compareTo(SerializationConfigurationType other) {
        int compareName = this.qualifiedJavaName.compareTo(other.qualifiedJavaName);
        if (compareName != 0) {
            return compareName;
        }
        int compareCondition = this.condition.compareTo(other.condition);
        if (compareCondition != 0) {
            return compareCondition;
        }
        Comparator<String> nullsFirstCompare = Comparator.nullsFirst(Comparator.naturalOrder());
        return nullsFirstCompare.compare(this.qualifiedCustomTargetConstructorJavaName, other.qualifiedCustomTargetConstructorJavaName);
    }
}

