/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver.launcher;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BundleLauncherUtil {
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private static final Pattern SAFE_SHELL_ARG = Pattern.compile("[A-Za-z0-9@%_\\-+=:,./]+");

    static String digest(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(value.getBytes(StandardCharsets.UTF_8));
            return BundleLauncherUtil.toHex(md.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new Error(ex);
        }
    }

    static String toHex(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(HEX[b >> 4 & 0xF]);
            r.append(HEX[b & 0xF]);
        }
        return r.toString();
    }

    static String quoteShellArg(String arg) {
        if (arg.isEmpty()) {
            return "''";
        }
        Matcher m = SAFE_SHELL_ARG.matcher(arg);
        if (m.matches()) {
            return arg;
        }
        return "'" + arg.replace("'", "'\"'\"'") + "'";
    }
}

