/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.hosted.RuntimeCompilationFeature;
import com.oracle.svm.graal.meta.SubstrateUniverseFactory;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.truffle.HostedTruffleConstantFieldProvider;
import com.oracle.svm.truffle.SubstrateHostInliningPhase;
import com.oracle.svm.truffle.SubstrateTruffleHostEnvironmentLookup;
import com.oracle.svm.truffle.TruffleBaseFeature;
import com.oracle.svm.truffle.TruffleSupport;
import com.oracle.svm.truffle.api.SubstrateThreadLocalHandshake;
import com.oracle.svm.truffle.api.SubstrateThreadLocalHandshakeSnippets;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import com.oracle.svm.truffle.api.SubstrateTruffleRuntime;
import com.oracle.svm.truffle.api.SubstrateTruffleUniverseFactory;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.StringUtil;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.runtime.TruffleCallBoundary;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.phases.HighTier;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.InsertGuardFencesPhase;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.compiler.KnownTruffleTypes;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.host.HostInliningPhase;
import org.graalvm.compiler.truffle.compiler.host.TruffleHostEnvironment;
import org.graalvm.compiler.truffle.compiler.nodes.asserts.NeverPartOfCompilationNode;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class TruffleFeature
implements InternalFeature {
    private final Set<ResolvedJavaMethod> blocklistMethods = new HashSet<ResolvedJavaMethod>();
    private final Set<ResolvedJavaMethod> tempTargetAllowlistMethods = new HashSet<ResolvedJavaMethod>();
    private final Set<ResolvedJavaMethod> warnMethods = new HashSet<ResolvedJavaMethod>();
    private final Set<Pair<ResolvedJavaMethod, String>> neverPartOfCompilationViolations = ConcurrentHashMap.newKeySet();
    Set<AnalysisMethod> runtimeCompiledMethods;

    public String getURL() {
        return "https://github.com/oracle/graal/blob/master/substratevm/src/com.oracle.svm.truffle/src/com/oracle/svm/truffle/TruffleFeature.java";
    }

    public String getDescription() {
        return "Provides support for Truffle runtime compilation";
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{SubstrateThreadLocalHandshake.FOREIGN_POLL});
    }

    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        new SubstrateThreadLocalHandshakeSnippets(options, providers, lowerings);
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(RuntimeCompilationFeature.getRuntimeCompilationFeature(), TruffleBaseFeature.class);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return TruffleFeature.isInConfiguration();
    }

    public static boolean isInConfiguration() {
        String property;
        if (!Boolean.getBoolean("truffle.UseFallbackRuntime") && (property = System.getProperty("truffle.TruffleRuntime")) != null) {
            return property.equals("com.oracle.svm.truffle.api.SubstrateTruffleRuntime");
        }
        return false;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        UserError.guarantee((boolean)(Truffle.getRuntime() instanceof SubstrateTruffleRuntime), (String)"TruffleFeature requires SubstrateTruffleRuntime", (Object[])new Object[0]);
        SubstrateTruffleRuntime truffleRuntime = (SubstrateTruffleRuntime)Truffle.getRuntime();
        truffleRuntime.resetHosted();
        RuntimeCompilationFeature.singleton().setUniverseFactory((SubstrateUniverseFactory)new SubstrateTruffleUniverseFactory(truffleRuntime));
    }

    public void cleanup() {
        if (Truffle.getRuntime() instanceof SubstrateTruffleRuntime) {
            ((SubstrateTruffleRuntime)Truffle.getRuntime()).resetNativeImageState();
        }
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        access.getHostVM().registerNeverInlineTrivialHandler(this::neverInlineTrivial);
        if (!ImageSingletons.contains(TruffleSupport.class)) {
            ImageSingletons.add(TruffleSupport.class, (Object)new TruffleSupport());
        }
        ((TruffleBaseFeature)ImageSingletons.lookup(TruffleBaseFeature.class)).setGraalGraphObjectReplacer(RuntimeCompilationFeature.singleton().getObjectReplacer());
    }

    private void registerNeverPartOfCompilation(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, CompilerAsserts.class);
        r.setAllowOverwrite(true);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("neverPartOfCompilation", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                return TruffleFeature.this.handleNeverPartOfCompilation(b, targetMethod, null);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("neverPartOfCompilation", new Type[]{String.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode message) {
                return TruffleFeature.this.handleNeverPartOfCompilation(b, targetMethod, message);
            }
        });
    }

    private boolean handleNeverPartOfCompilation(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode messageNode) {
        String message = "CompilerAsserts.neverPartOfCompilation()";
        if (messageNode != null && messageNode.isConstant()) {
            message = messageNode.asConstant().toValueString();
        }
        NeverPartOfCompilationNode neverPartOfCompilation = (NeverPartOfCompilationNode)b.add((Node)new NeverPartOfCompilationNode(message));
        if (((Boolean)Options.TruffleCheckNeverPartOfCompilation.getValue()).booleanValue() && !neverPartOfCompilation.stateAfter().getMethod().getDeclaringClass().equals((Object)targetMethod.getDeclaringClass())) {
            LinkedList<String> callTree = new LinkedList<String>();
            for (FrameState cur = neverPartOfCompilation.stateAfter(); cur != null; cur = cur.outerFrameState()) {
                callTree.add(cur.getMethod().format("%H.%n(%p)"));
            }
            callTree.removeLast();
            this.neverPartOfCompilationViolations.add((Pair<ResolvedJavaMethod, String>)Pair.create((Object)b.getMethod(), (Object)String.join((CharSequence)",", callTree)));
        }
        return true;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        SubstrateTruffleRuntime truffleRuntime = (SubstrateTruffleRuntime)Truffle.getRuntime();
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        TruffleHostEnvironment.overrideLookup((TruffleHostEnvironment.Lookup)new SubstrateTruffleHostEnvironmentLookup(truffleRuntime, (MetaAccessProvider)config.getMetaAccess()));
        ((TruffleBaseFeature)ImageSingletons.lookup(TruffleBaseFeature.class)).setProfilingEnabled(truffleRuntime.isProfilingEnabled());
        for (Class initType : truffleRuntime.getLookupTypes()) {
            config.registerAsUsed(initType, (Object)"Truffle runtime init type.");
        }
        config.registerAsRoot((AnalysisMethod)SubstrateThreadLocalHandshake.FOREIGN_POLL.findMethod((MetaAccessProvider)config.getMetaAccess()), true, "Truffle thread local foreign poll, registered in " + String.valueOf(TruffleFeature.class), new MultiMethod.MultiMethodKey[0]);
        RuntimeCompilationFeature runtimeCompilationFeature = RuntimeCompilationFeature.singleton();
        SnippetReflectionProvider snippetReflection = runtimeCompilationFeature.getHostedProviders().getSnippetReflection();
        SubstrateTruffleCompiler truffleCompiler = truffleRuntime.preinitializeTruffleCompiler();
        truffleRuntime.initializeKnownMethods((MetaAccessProvider)config.getMetaAccess());
        truffleRuntime.initializeHostedKnownMethods(config.getUniverse().getOriginalMetaAccess());
        PartialEvaluator partialEvaluator = truffleCompiler.getPartialEvaluator();
        TruffleFeature.registerKnownTruffleFields(config, partialEvaluator.getTypes());
        GraphBuilderConfiguration graphBuilderConfig = partialEvaluator.getGraphBuilderConfigPrototype();
        TruffleAllowInliningPredicate allowInliningPredicate = new TruffleAllowInliningPredicate(runtimeCompilationFeature.getHostedProviders().getReplacements(), graphBuilderConfig.getPlugins().getInvocationPlugins(), partialEvaluator, this::allowRuntimeCompilation);
        if (((Boolean)Options.TruffleInlineDuringParsing.getValue()).booleanValue() && !SubstrateOptions.parseOnce()) {
            graphBuilderConfig.getPlugins().appendInlineInvokePlugin((InlineInvokePlugin)new TruffleParsingInlineInvokePlugin(config.getHostVM(), allowInliningPredicate));
        }
        runtimeCompilationFeature.registerAllowInliningPredicate(allowInliningPredicate::allowInlining);
        this.registerNeverPartOfCompilation(graphBuilderConfig.getPlugins().getInvocationPlugins());
        graphBuilderConfig.getPlugins().getInvocationPlugins().closeRegistration();
        Providers peProviders = partialEvaluator.getProviders();
        HostedProviders newHostedProviders = new HostedProviders(peProviders.getMetaAccess(), peProviders.getCodeCache(), peProviders.getConstantReflection(), (ConstantFieldProvider)new HostedTruffleConstantFieldProvider(peProviders.getConstantFieldProvider()), peProviders.getForeignCalls(), peProviders.getLowerer(), peProviders.getReplacements(), peProviders.getStampProvider(), snippetReflection, runtimeCompilationFeature.getHostedProviders().getWordTypes(), runtimeCompilationFeature.getHostedProviders().getPlatformConfigurationProvider(), runtimeCompilationFeature.getHostedProviders().getMetaAccessExtensionProvider(), runtimeCompilationFeature.getHostedProviders().getLoopsDataProvider());
        newHostedProviders.setGraphBuilderPlugins(graphBuilderConfig.getPlugins());
        runtimeCompilationFeature.initializeRuntimeCompilationConfiguration(newHostedProviders, graphBuilderConfig, this::allowRuntimeCompilation, this::deoptimizeOnException);
        for (ResolvedJavaMethod method : partialEvaluator.getCompilationRootMethods()) {
            runtimeCompilationFeature.prepareMethodForRuntimeCompilation(method, config);
        }
        runtimeCompilationFeature.initializeAnalysisProviders(config.getBigBang(), HostedTruffleConstantFieldProvider::new);
        this.initializeMethodBlocklist((MetaAccessProvider)config.getMetaAccess(), (Feature.FeatureAccess)access);
        for (ResolvedJavaMethod method : truffleRuntime.getAnyFrameMethod()) {
            runtimeCompilationFeature.requireFrameInformationForMethod(method, config, true);
        }
        config.registerAsInHeap(TruffleSupport.singleton().getOptimizedCallTargetClass(), (Object)("Concrete subclass of OptimizedCallTarget registered by " + String.valueOf(TruffleFeature.class)));
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.PolyglotEngineImpl", "resetFallbackEngine", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.preInitializeEngine();
        ((FeatureImpl.BeforeAnalysisAccessImpl)access).ensureInitialized("org.graalvm.polyglot.io.IOHelper");
        config.registerSubtypeReachabilityHandler((acc, klass) -> {
            FeatureImpl.DuringAnalysisAccessImpl impl = (FeatureImpl.DuringAnalysisAccessImpl)acc;
            Boolean modified = (Boolean)TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.runtime.BytecodeOSRRootNode", "initializeClassUsingDeprecatedFrameTransfer", Collections.singleton(Class.class), klass);
            if (modified != null && modified.booleanValue() && !impl.concurrentReachabilityHandlers()) {
                impl.requireAnalysisIteration();
            }
        }, BytecodeOSRNode.class);
    }

    private static void registerKnownTruffleFields(FeatureImpl.BeforeAnalysisAccessImpl config, KnownTruffleTypes knownTruffleFields) {
        for (Class<?> klass = knownTruffleFields.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
            for (Field field : klass.getDeclaredFields()) {
                if (!Modifier.isPublic(field.getModifiers())) continue;
                try {
                    Object value = field.get(knownTruffleFields);
                    if (!(value instanceof ResolvedJavaField)) continue;
                    config.registerAsAccessed((AnalysisField)value, (Object)"known truffle field");
                }
                catch (IllegalAccessException ex) {
                    throw VMError.shouldNotReachHere((Throwable)ex);
                }
            }
        }
    }

    private boolean allowRuntimeCompilation(ResolvedJavaMethod method) {
        if (TruffleFeature.runtimeCompilationForbidden(method)) {
            return false;
        }
        return !this.isBlocklisted(method);
    }

    private static boolean runtimeCompilationForbidden(ResolvedJavaMethod method) {
        Uninterruptible uninterruptibleAnnotation;
        if (method.getAnnotation(CompilerDirectives.TruffleBoundary.class) != null) {
            return true;
        }
        if (Uninterruptible.Utils.isUninterruptible((AnnotatedElement)method) && ((uninterruptibleAnnotation = Uninterruptible.Utils.getAnnotation((AnnotatedElement)method)) == null || !uninterruptibleAnnotation.mayBeInlined())) {
            return true;
        }
        if (!method.canBeInlined()) {
            return true;
        }
        return method.getAnnotation(TruffleCallBoundary.class) != null;
    }

    boolean isBlocklisted(ResolvedJavaMethod method) {
        if (!((AnalysisMethod)method).allowRuntimeCompilation()) {
            return true;
        }
        return this.blocklistMethods.contains(method);
    }

    private boolean deoptimizeOnException(ResolvedJavaMethod method) {
        if (method == null) {
            return false;
        }
        CompilerDirectives.TruffleBoundary truffleBoundary = (CompilerDirectives.TruffleBoundary)method.getAnnotation(CompilerDirectives.TruffleBoundary.class);
        return truffleBoundary != null && truffleBoundary.transferToInterpreterOnException();
    }

    private void initializeMethodBlocklist(MetaAccessProvider metaAccess, Feature.FeatureAccess featureAccess) {
        this.blocklistMethod(metaAccess, Object.class, "equals", Object.class);
        this.blocklistMethod(metaAccess, Object.class, "hashCode", new Class[0]);
        this.blocklistMethod(metaAccess, Object.class, "toString", new Class[0]);
        this.blocklistMethod(metaAccess, String.class, "valueOf", Object.class);
        this.blocklistMethod(metaAccess, String.class, "getBytes", new Class[0]);
        this.blocklistMethod(metaAccess, String.class, "indexOf", Integer.TYPE);
        this.blocklistMethod(metaAccess, String.class, "indexOf", Integer.TYPE, Integer.TYPE);
        this.blocklistMethod(metaAccess, String.class, "indexOf", String.class);
        this.blocklistMethod(metaAccess, String.class, "indexOf", String.class, Integer.TYPE);
        this.blocklistMethod(metaAccess, Throwable.class, "fillInStackTrace", Integer.TYPE);
        this.blocklistMethod(metaAccess, Throwable.class, "initCause", Throwable.class);
        this.blocklistMethod(metaAccess, Throwable.class, "addSuppressed", Throwable.class);
        this.blocklistMethod(metaAccess, System.class, "getProperty", String.class);
        this.blocklistAllMethods(metaAccess, AssertionError.class);
        this.blocklistAllMethods(metaAccess, BigInteger.class);
        this.blocklistAllMethods(metaAccess, BigDecimal.class);
        this.blocklistAllMethods(metaAccess, Comparable.class);
        this.blocklistAllMethods(metaAccess, Comparator.class);
        this.blocklistAllMethods(metaAccess, Collection.class);
        this.blocklistAllMethods(metaAccess, List.class);
        this.blocklistAllMethods(metaAccess, Set.class);
        this.blocklistAllMethods(metaAccess, Map.class);
        this.blocklistAllMethods(metaAccess, Map.Entry.class);
        this.blocklistAllMethods(metaAccess, TreeMap.class);
        this.blocklistAllMethods(metaAccess, HashMap.class);
        this.blocklistAllMethods(metaAccess, ConcurrentHashMap.class);
        this.blocklistAllMethods(metaAccess, WeakHashMap.class);
        this.blocklistAllMethods(metaAccess, IdentityHashMap.class);
        this.blocklistAllMethods(metaAccess, Iterable.class);
        this.blocklistAllMethods(metaAccess, Iterator.class);
        this.blocklistAllMethods(metaAccess, ListIterator.class);
        this.blocklistAllMethods(metaAccess, ReentrantLock.class);
        this.removeFromBlocklist(metaAccess, BigInteger.class, "signum", new Class[0]);
        this.removeFromBlocklist(metaAccess, ReentrantLock.class, "isLocked", new Class[0]);
        this.removeFromBlocklist(metaAccess, ReentrantLock.class, "isHeldByCurrentThread", new Class[0]);
        this.removeFromBlocklist(metaAccess, ReentrantLock.class, "getOwner", new Class[0]);
        this.removeFromBlocklist(metaAccess, ReentrantLock.class, "<init>", new Class[0]);
        this.blocklistAllMethods(metaAccess, StringBuffer.class);
        this.blocklistAllMethods(metaAccess, Vector.class);
        this.blocklistAllMethods(metaAccess, Hashtable.class);
        this.blocklistAllMethods(metaAccess, BiConsumer.class);
        this.blocklistAllMethods(metaAccess, BiFunction.class);
        this.blocklistAllMethods(metaAccess, BinaryOperator.class);
        this.blocklistAllMethods(metaAccess, BiPredicate.class);
        this.blocklistAllMethods(metaAccess, BooleanSupplier.class);
        this.blocklistAllMethods(metaAccess, Consumer.class);
        this.blocklistAllMethods(metaAccess, DoubleBinaryOperator.class);
        this.blocklistAllMethods(metaAccess, DoubleConsumer.class);
        this.blocklistAllMethods(metaAccess, DoubleFunction.class);
        this.blocklistAllMethods(metaAccess, DoublePredicate.class);
        this.blocklistAllMethods(metaAccess, DoubleSupplier.class);
        this.blocklistAllMethods(metaAccess, DoubleToIntFunction.class);
        this.blocklistAllMethods(metaAccess, DoubleToLongFunction.class);
        this.blocklistAllMethods(metaAccess, DoubleUnaryOperator.class);
        this.blocklistAllMethods(metaAccess, Function.class);
        this.blocklistAllMethods(metaAccess, IntBinaryOperator.class);
        this.blocklistAllMethods(metaAccess, IntConsumer.class);
        this.blocklistAllMethods(metaAccess, IntFunction.class);
        this.blocklistAllMethods(metaAccess, IntPredicate.class);
        this.blocklistAllMethods(metaAccess, IntSupplier.class);
        this.blocklistAllMethods(metaAccess, IntToDoubleFunction.class);
        this.blocklistAllMethods(metaAccess, IntToLongFunction.class);
        this.blocklistAllMethods(metaAccess, IntUnaryOperator.class);
        this.blocklistAllMethods(metaAccess, LongBinaryOperator.class);
        this.blocklistAllMethods(metaAccess, LongConsumer.class);
        this.blocklistAllMethods(metaAccess, LongFunction.class);
        this.blocklistAllMethods(metaAccess, LongPredicate.class);
        this.blocklistAllMethods(metaAccess, LongSupplier.class);
        this.blocklistAllMethods(metaAccess, LongToDoubleFunction.class);
        this.blocklistAllMethods(metaAccess, LongToIntFunction.class);
        this.blocklistAllMethods(metaAccess, LongUnaryOperator.class);
        this.blocklistAllMethods(metaAccess, ObjDoubleConsumer.class);
        this.blocklistAllMethods(metaAccess, ObjIntConsumer.class);
        this.blocklistAllMethods(metaAccess, ObjLongConsumer.class);
        this.blocklistAllMethods(metaAccess, Predicate.class);
        this.blocklistAllMethods(metaAccess, Supplier.class);
        this.blocklistAllMethods(metaAccess, ToDoubleBiFunction.class);
        this.blocklistAllMethods(metaAccess, ToDoubleFunction.class);
        this.blocklistAllMethods(metaAccess, ToIntBiFunction.class);
        this.blocklistAllMethods(metaAccess, ToIntFunction.class);
        this.blocklistAllMethods(metaAccess, ToLongBiFunction.class);
        this.blocklistAllMethods(metaAccess, ToLongFunction.class);
        this.blocklistAllMethods(metaAccess, UnaryOperator.class);
        this.blocklistAllMethods(metaAccess, featureAccess.findClassByName("java.lang.StringConcatHelper"));
        this.warnAllMethods(metaAccess, JavaStackWalker.class);
        this.warnAllMethods(metaAccess, Deoptimizer.class);
        this.warnAllMethods(metaAccess, Heap.getHeap().getClass());
        this.tempTargetAllowlistMethod(metaAccess, Function.class, "apply", Object.class);
        this.tempTargetAllowlistMethod(metaAccess, Predicate.class, "test", Object.class);
        this.tempTargetAllowlistMethod(metaAccess, LongBinaryOperator.class, "applyAsLong", Long.TYPE, Long.TYPE);
        this.tempTargetAllowlistMethod(metaAccess, IntBinaryOperator.class, "applyAsInt", Integer.TYPE, Integer.TYPE);
        this.tempTargetAllowlistMethod(metaAccess, IntBinaryOperator.class, "applyAsInt", Integer.TYPE, Integer.TYPE);
        this.tempTargetAllowlistMethod(metaAccess, List.class, "add", Object.class);
        this.tempTargetAllowlistMethod(metaAccess, List.class, "size", new Class[0]);
        this.tempTargetAllowlistMethod(metaAccess, List.class, "isEmpty", new Class[0]);
        this.tempTargetAllowlistMethod(metaAccess, List.class, "clear", new Class[0]);
        this.tempTargetAllowlistMethod(metaAccess, List.class, "get", Integer.TYPE);
        this.tempTargetAllowlistMethod(metaAccess, List.class, "remove", Integer.TYPE);
        this.tempTargetAllowlistMethod(metaAccess, List.class, "toArray", new Class[0]);
        this.tempTargetAllowlistMethod(metaAccess, List.class, "toArray", Object[].class);
        this.tempTargetAllowlistMethod(metaAccess, Iterator.class, "next", new Class[0]);
        this.tempTargetAllowlistMethod(metaAccess, Iterator.class, "hasNext", new Class[0]);
        this.tempTargetAllowlistMethod(metaAccess, Iterable.class, "iterator", new Class[0]);
        this.tempTargetAllowlistMethod(metaAccess, Object.class, "equals", Object.class);
        this.tempTargetAllowlistMethod(metaAccess, Object.class, "hashCode", new Class[0]);
    }

    private void blocklistAllMethods(MetaAccessProvider metaAccess, Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            this.blocklistMethods.add(metaAccess.lookupJavaMethod((Executable)method));
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            this.blocklistMethods.add(metaAccess.lookupJavaMethod(executable));
        }
    }

    private void blocklistMethod(MetaAccessProvider metaAccess, Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            this.blocklistMethods.add(metaAccess.lookupJavaMethod((Executable)clazz.getDeclaredMethod(name, parameterTypes)));
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere((Throwable)ex);
        }
    }

    private void tempTargetAllowlistMethod(MetaAccessProvider metaAccess, Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            this.tempTargetAllowlistMethods.add(metaAccess.lookupJavaMethod((Executable)clazz.getDeclaredMethod(name, parameterTypes)));
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere((Throwable)ex);
        }
    }

    private void removeFromBlocklist(MetaAccessProvider metaAccess, Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Executable method = "<init>".equals(name) ? clazz.getDeclaredConstructor(parameterTypes) : clazz.getDeclaredMethod(name, parameterTypes);
            if (!this.blocklistMethods.remove(metaAccess.lookupJavaMethod(method))) {
                throw VMError.shouldNotReachHereUnexpectedInput(method);
            }
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere((Throwable)ex);
        }
    }

    private void warnAllMethods(MetaAccessProvider metaAccess, Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (AnnotationAccess.getAnnotationTypes((AnnotatedElement)method).length != 0 || ((Executable)method).getName().startsWith("get") || ((Executable)method).getName().startsWith("set")) continue;
            this.warnMethods.add(metaAccess.lookupJavaMethod((Executable)method));
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            if (AnnotationAccess.getAnnotationTypes((AnnotatedElement)executable).length != 0) continue;
            this.warnMethods.add(metaAccess.lookupJavaMethod(executable));
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess config) {
        Optional optionalFrameType;
        boolean printBlockListViolations;
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)config;
        boolean failBlockListViolations = Options.TruffleCheckBlackListedMethods.hasBeenSet() ? ((Boolean)Options.TruffleCheckBlackListedMethods.getValue()).booleanValue() : ((Boolean)Options.TruffleCheckBlockListMethods.getValue()).booleanValue();
        boolean bl = printBlockListViolations = (Boolean)RuntimeCompilationFeature.Options.PrintRuntimeCompileMethods.getValue() != false || failBlockListViolations;
        if (printBlockListViolations) {
            TreeSet<RuntimeCompilationFeature.RuntimeCompilationCandidate> blocklistViolations = new TreeSet<RuntimeCompilationFeature.RuntimeCompilationCandidate>(RuntimeCompilationFeature.singleton().getRuntimeCompilationComparator());
            for (RuntimeCompilationFeature.RuntimeCompilationCandidate runtimeCompilationCandidate : RuntimeCompilationFeature.singleton().getAllRuntimeCompilationCandidates()) {
                boolean tempAllow;
                if (TruffleFeature.runtimeCompilationForbidden((ResolvedJavaMethod)runtimeCompilationCandidate.getImplementationMethod()) || !this.isBlocklisted((ResolvedJavaMethod)runtimeCompilationCandidate.getImplementationMethod()) || (tempAllow = !runtimeCompilationCandidate.getTargetMethod().equals((Object)runtimeCompilationCandidate.getImplementationMethod()) && this.tempTargetAllowlistMethods.contains(runtimeCompilationCandidate.getTargetMethod()) && !this.isBlocklisted((ResolvedJavaMethod)runtimeCompilationCandidate.getImplementationMethod()))) continue;
                blocklistViolations.add(runtimeCompilationCandidate);
            }
            if (!blocklistViolations.isEmpty()) {
                System.out.println();
                System.out.println("=== Found " + blocklistViolations.size() + " compilation blocklist violations ===");
                System.out.println();
                for (RuntimeCompilationFeature.RuntimeCompilationCandidate runtimeCompilationCandidate : blocklistViolations) {
                    System.out.println("Blocklisted method");
                    System.out.format("   %s (target: %s)%n", runtimeCompilationCandidate.getImplementationMethod().format("%H.%n(%p)"), runtimeCompilationCandidate.getTargetMethod().format("%H.%n(%p)"));
                    System.out.println("trace:");
                    RuntimeCompilationFeature.singleton().getCallTrace(runtimeCompilationCandidate).forEach(item -> System.out.println("  " + item));
                }
                if (failBlockListViolations) {
                    throw VMError.shouldNotReachHere((String)"Blocklisted methods are reachable for runtime compilation");
                }
            }
        }
        HashSet<RuntimeCompilationFeature.RuntimeCompilationCandidate> warnViolations = new HashSet<RuntimeCompilationFeature.RuntimeCompilationCandidate>();
        for (RuntimeCompilationFeature.RuntimeCompilationCandidate runtimeCompilationCandidate : RuntimeCompilationFeature.singleton().getAllRuntimeCompilationCandidates()) {
            AnalysisMethod method = runtimeCompilationCandidate.getImplementationMethod();
            if (!this.warnMethods.contains(method)) continue;
            warnViolations.add(runtimeCompilationCandidate);
        }
        if (warnViolations.size() > 0) {
            LogUtils.warning((String)"Suspicious methods reachable for runtime compilation.");
            System.out.println("Check the complete tree of reachable methods using the option " + RuntimeCompilationFeature.Options.PrintRuntimeCompileMethods.getDescriptor().getFieldName());
            for (RuntimeCompilationFeature.RuntimeCompilationCandidate runtimeCompilationCandidate : warnViolations) {
                System.out.println("Suspicious method: " + runtimeCompilationCandidate.getImplementationMethod().format("%H.%n(%p)"));
                System.out.println("trace:");
                RuntimeCompilationFeature.singleton().getCallTrace(runtimeCompilationCandidate).forEach(item -> System.out.println("  " + item));
            }
        }
        if (this.neverPartOfCompilationViolations.size() > 0) {
            System.out.println("Error: CompilerAsserts.neverPartOfCompilation reachable for runtime compilation from " + this.neverPartOfCompilationViolations.size() + " places:");
            for (Pair pair : this.neverPartOfCompilationViolations) {
                System.out.println("called from");
                System.out.println("(inlined call path): " + (String)pair.getRight());
                RuntimeCompilationFeature.singleton().getCallTrace((ResolvedJavaMethod)pair.getLeft()).forEach(item -> System.out.println(" " + item));
            }
            throw VMError.shouldNotReachHere((String)"CompilerAsserts.neverPartOfCompilation reachable for runtime compilation");
        }
        if (((Boolean)Options.TruffleCheckFrameImplementation.getValue()).booleanValue() && (optionalFrameType = access.getMetaAccess().optionalLookupJavaType(Frame.class)).isPresent()) {
            HostedType hostedType = (HostedType)optionalFrameType.get();
            HashSet<HostedType> implementations = new HashSet<HostedType>();
            TruffleFeature.collectImplementations(hostedType, implementations);
            if (implementations.size() > 1) {
                throw UserError.abort((String)"More than one implementation of %s found. For performance reasons, Truffle languages must not provide new implementations, and instead only use the single implementation provided by the Truffle runtime. To disable this check, add %s to the native-image command line. Classes found are %s.", (Object[])new Object[]{Frame.class.getTypeName(), SubstrateOptionsParser.commandArgument(Options.TruffleCheckFrameImplementation, (String)"-"), StringUtil.joinSingleQuoted((String[])((String[])implementations.stream().map(m -> m.toJavaName(true)).toArray(String[]::new)))});
            }
            assert (implementations.size() == 0 || ((HostedType)implementations.iterator().next()).equals(hostedType.getSingleImplementor()));
        }
    }

    private boolean neverInlineTrivial(AnalysisMethod caller, AnalysisMethod callee) {
        TruffleHostEnvironment env = TruffleHostEnvironment.get((ResolvedJavaMethod)callee);
        if (env == null) {
            return false;
        }
        if (HostInliningPhase.shouldDenyTrivialInliningInAllMethods((TruffleHostEnvironment)env, (ResolvedJavaMethod)callee)) {
            return true;
        }
        return (this.runtimeCompiledMethods == null || this.runtimeCompiledMethods.contains(caller)) && HostInliningPhase.shouldDenyTrivialInlining((TruffleHostEnvironment)env, (ResolvedJavaMethod)callee);
    }

    private static void collectImplementations(HostedType type, Set<HostedType> implementations) {
        for (HostedType subType : type.getSubTypes()) {
            if (!subType.isAbstract()) {
                implementations.add(subType);
            }
            TruffleFeature.collectImplementations(subType, implementations);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        if (((Boolean)Options.PrintStaticTruffleBoundaries.getValue()).booleanValue()) {
            TruffleFeature.printStaticTruffleBoundaries();
        }
        SubstrateTruffleRuntime truffleRuntime = (SubstrateTruffleRuntime)Truffle.getRuntime();
        FeatureImpl.AfterAnalysisAccessImpl config = (FeatureImpl.AfterAnalysisAccessImpl)access;
        truffleRuntime.initializeHostedKnownMethods((MetaAccessProvider)config.getMetaAccess());
        this.runtimeCompiledMethods = new LinkedHashSet<AnalysisMethod>();
        this.runtimeCompiledMethods.addAll(Arrays.asList(config.getMetaAccess().lookupJavaType(CompilerDirectives.class).getDeclaredMethods(false)));
        this.runtimeCompiledMethods.addAll(Arrays.asList(config.getMetaAccess().lookupJavaType(CompilerAsserts.class).getDeclaredMethods(false)));
        for (RuntimeCompilationFeature.RuntimeCompiledMethod runtimeCompiledMethod : RuntimeCompilationFeature.singleton().getRuntimeCompiledMethods()) {
            this.runtimeCompiledMethods.add(runtimeCompiledMethod.getMethod());
            for (ResolvedJavaMethod method : runtimeCompiledMethod.getInlinedMethods()) {
                if (!(method instanceof AnalysisMethod)) {
                    throw VMError.shouldNotReachHere((String)"method should be an analysis method");
                }
                if (method.getAnnotation(CompilerDirectives.TruffleBoundary.class) != null) {
                    throw VMError.shouldNotReachHere((String)"method used during runtime compilation must never be annotated with a truffle boundary");
                }
                this.runtimeCompiledMethods.add((AnalysisMethod)method);
            }
        }
    }

    private static void printStaticTruffleBoundaries() {
        HashSet<ResolvedJavaMethod> foundBoundaries = new HashSet<ResolvedJavaMethod>();
        int callSiteCount = 0;
        int calleeCount = 0;
        for (RuntimeCompilationFeature.RuntimeCompiledMethod runtimeCompiledMethod : RuntimeCompilationFeature.singleton().getRuntimeCompiledMethods()) {
            for (ResolvedJavaMethod targetMethod : runtimeCompiledMethod.getInvokeTargets()) {
                CompilerDirectives.TruffleBoundary truffleBoundary = (CompilerDirectives.TruffleBoundary)targetMethod.getAnnotation(CompilerDirectives.TruffleBoundary.class);
                if (truffleBoundary == null) continue;
                ++callSiteCount;
                if (foundBoundaries.contains(targetMethod)) continue;
                foundBoundaries.add(targetMethod);
                System.out.println("Truffle boundary found: " + String.valueOf(targetMethod));
                ++calleeCount;
            }
        }
        System.out.printf("Number of Truffle call boundaries: %d, number of unique called methods outside the boundary: %d%n", callSiteCount, calleeCount);
    }

    public void registerGraalPhases(Providers providers, SnippetReflectionProvider snippetReflection, Suites suites, boolean hosted) {
        if (hosted && ((Boolean)HostInliningPhase.Options.TruffleHostInlining.getValue(HostedOptionValues.singleton())).booleanValue() && suites.getHighTier() instanceof HighTier) {
            suites.getHighTier().prependPhase((BasePhase)new SubstrateHostInliningPhase(CanonicalizerPhase.create()));
        }
        if (!hosted && suites.getMidTier().findPhase(InsertGuardFencesPhase.class, true) == null) {
            suites.getMidTier().appendPhase((BasePhase)new InsertGuardFencesPhase());
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> PrintStaticTruffleBoundaries = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> TruffleCheckNeverPartOfCompilation = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<Boolean> TruffleCheckFrameImplementation = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<Boolean> TruffleCheckBlackListedMethods = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<Boolean> TruffleCheckBlockListMethods = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<Boolean> TruffleInlineDuringParsing = new HostedOptionKey((Object)true);
    }

    static class TruffleAllowInliningPredicate {
        private final Replacements replacements;
        private final InvocationPlugins invocationPlugins;
        private final PartialEvaluator partialEvaluator;
        private final Predicate<ResolvedJavaMethod> allowRuntimeCompilationPredicate;

        TruffleAllowInliningPredicate(Replacements replacements, InvocationPlugins invocationPlugins, PartialEvaluator partialEvaluator, Predicate<ResolvedJavaMethod> allowRuntimeCompilationPredicate) {
            this.replacements = replacements;
            this.invocationPlugins = invocationPlugins;
            this.partialEvaluator = partialEvaluator;
            this.allowRuntimeCompilationPredicate = allowRuntimeCompilationPredicate;
        }

        public RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision allowInlining(GraphBuilderContext builder, ResolvedJavaMethod target) {
            if (target.hasNeverInlineDirective()) {
                return RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision.INLINING_DISALLOWED;
            }
            if (this.invocationPlugins.lookupInvocation(target, builder.getOptions()) != null) {
                return RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision.INLINING_DISALLOWED;
            }
            if (target.getAnnotation(ExplodeLoop.class) != null) {
                return RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision.INLINING_DISALLOWED;
            }
            if (builder.getMethod().getAnnotation(ExplodeLoop.class) != null) {
                return RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision.INLINING_DISALLOWED;
            }
            if (this.replacements.hasSubstitution(target, builder.getOptions())) {
                return RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision.INLINING_DISALLOWED;
            }
            for (ResolvedJavaMethod m : this.partialEvaluator.getNeverInlineMethods()) {
                if (!target.equals((Object)m)) continue;
                return RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision.INLINING_DISALLOWED;
            }
            if (target.getCode() != null && this.allowRuntimeCompilationPredicate.test(target)) {
                return RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision.INLINE;
            }
            return RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision.NO_DECISION;
        }
    }

    static class TruffleParsingInlineInvokePlugin
    implements InlineInvokePlugin {
        private final SVMHost hostVM;
        TruffleAllowInliningPredicate inlineCriteria;

        TruffleParsingInlineInvokePlugin(SVMHost hostVM, TruffleAllowInliningPredicate inlineCriteria) {
            this.hostVM = hostVM;
            this.inlineCriteria = inlineCriteria;
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
            assert (!SubstrateOptions.parseOnce()) : "inlining during parsing is not enabled with parse once";
            RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision result = this.inlineCriteria.allowInlining(builder, original);
            switch (result) {
                case NO_DECISION: {
                    return null;
                }
                case INLINING_DISALLOWED: {
                    return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
                }
            }
            assert (result == RuntimeCompilationFeature.AllowInliningPredicate.InlineDecision.INLINE);
            if (this.hostVM.isAnalysisTrivialMethod((AnalysisMethod)original) && builder.getDepth() < (Integer)BytecodeParserOptions.InlineDuringParsingMaxDepth.getValue(HostedOptionValues.singleton())) {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)original);
            }
            return null;
        }
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(TruffleFeature.class);
        }
    }
}

